package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{SecretNameType, SecretARNType}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreSecretResponse(
    arn: Option[SecretARNType] = None,
    name: Option[SecretNameType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.RestoreSecretResponse = {
    import RestoreSecretResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.RestoreSecretResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => SecretNameType.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.RestoreSecretResponse.ReadOnly =
    zio.aws.secretsmanager.model.RestoreSecretResponse.wrap(buildAwsValue())
}
object RestoreSecretResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.RestoreSecretResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.RestoreSecretResponse =
      zio.aws.secretsmanager.model.RestoreSecretResponse(
        arn.map(value => value),
        name.map(value => value)
      )
    def arn: Option[SecretARNType]
    def name: Option[SecretNameType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecretNameType] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.RestoreSecretResponse
  ) extends zio.aws.secretsmanager.model.RestoreSecretResponse.ReadOnly {
    override val arn: Option[SecretARNType] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Option[SecretNameType] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretNameType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.RestoreSecretResponse
  ): zio.aws.secretsmanager.model.RestoreSecretResponse.ReadOnly = new Wrapper(
    impl
  )
}
