package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  BooleanType,
  NonEmptyResourcePolicyType,
  SecretIdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyRequest(
    secretId: SecretIdType,
    resourcePolicy: NonEmptyResourcePolicyType,
    blockPublicPolicy: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .resourcePolicy(
        NonEmptyResourcePolicyType.unwrap(resourcePolicy): java.lang.String
      )
      .optionallyWith(
        blockPublicPolicy.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.blockPublicPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.secretsmanager.model.PutResourcePolicyRequest.wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.PutResourcePolicyRequest =
      zio.aws.secretsmanager.model.PutResourcePolicyRequest(
        secretId,
        resourcePolicy,
        blockPublicPolicy.map(value => value)
      )
    def secretId: SecretIdType
    def resourcePolicy: NonEmptyResourcePolicyType
    def blockPublicPolicy: Option[BooleanType]
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
    def getResourcePolicy: ZIO[Any, Nothing, NonEmptyResourcePolicyType] =
      ZIO.succeed(resourcePolicy)
    def getBlockPublicPolicy: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("blockPublicPolicy", blockPublicPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyRequest
  ) extends zio.aws.secretsmanager.model.PutResourcePolicyRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
    override val resourcePolicy: NonEmptyResourcePolicyType =
      zio.aws.secretsmanager.model.primitives
        .NonEmptyResourcePolicyType(impl.resourcePolicy())
    override val blockPublicPolicy: Option[BooleanType] = scala
      .Option(impl.blockPublicPolicy())
      .map(value => zio.aws.secretsmanager.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyRequest
  ): zio.aws.secretsmanager.model.PutResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
