package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{NameType, SecretARNType}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteResourcePolicyResponse(
    arn: Option[SecretARNType] = None,
    name: Option[NameType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyResponse = {
    import DeleteResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => NameType.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.DeleteResourcePolicyResponse.ReadOnly =
    zio.aws.secretsmanager.model.DeleteResourcePolicyResponse
      .wrap(buildAwsValue())
}
object DeleteResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.DeleteResourcePolicyResponse =
      zio.aws.secretsmanager.model.DeleteResourcePolicyResponse(
        arn.map(value => value),
        name.map(value => value)
      )
    def arn: Option[SecretARNType]
    def name: Option[NameType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyResponse
  ) extends zio.aws.secretsmanager.model.DeleteResourcePolicyResponse.ReadOnly {
    override val arn: Option[SecretARNType] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Option[NameType] = scala
      .Option(impl.name())
      .map(value => zio.aws.secretsmanager.model.primitives.NameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyResponse
  ): zio.aws.secretsmanager.model.DeleteResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
