package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class GetResourcePolicyResponse(
    policy: Optional[__string] = Optional.Absent,
    revisionId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.GetResourcePolicyResponse = {
    import GetResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.GetResourcePolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.GetResourcePolicyResponse.ReadOnly =
    zio.aws.schemas.model.GetResourcePolicyResponse.wrap(buildAwsValue())
}
object GetResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.GetResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.GetResourcePolicyResponse =
      zio.aws.schemas.model.GetResourcePolicyResponse(
        policy.map(value => value),
        revisionId.map(value => value)
      )
    def policy: Optional[__string]
    def revisionId: Optional[__string]
    def getPolicy: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("policy", policy)
    def getRevisionId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.GetResourcePolicyResponse
  ) extends zio.aws.schemas.model.GetResourcePolicyResponse.ReadOnly {
    override val policy: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: __string)
    override val revisionId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.GetResourcePolicyResponse
  ): zio.aws.schemas.model.GetResourcePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
