package zio.aws.schemas.model
import zio.aws.schemas.model.primitives.{__string, __timestampIso8601}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SearchSchemaVersionSummary(
    createdDate: Optional[__timestampIso8601] = Optional.Absent,
    schemaVersion: Optional[__string] = Optional.Absent,
    `type`: Optional[zio.aws.schemas.model.Type] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.SearchSchemaVersionSummary = {
    import SearchSchemaVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.SearchSchemaVersionSummary
      .builder()
      .optionallyWith(createdDate.map(value => value: Instant))(_.createdDate)
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.SearchSchemaVersionSummary.ReadOnly =
    zio.aws.schemas.model.SearchSchemaVersionSummary.wrap(buildAwsValue())
}
object SearchSchemaVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.SearchSchemaVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.SearchSchemaVersionSummary =
      zio.aws.schemas.model.SearchSchemaVersionSummary(
        createdDate.map(value => value),
        schemaVersion.map(value => value),
        `type`.map(value => value)
      )
    def createdDate: Optional[__timestampIso8601]
    def schemaVersion: Optional[__string]
    def `type`: Optional[zio.aws.schemas.model.Type]
    def getCreatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getType: ZIO[Any, AwsError, zio.aws.schemas.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.SearchSchemaVersionSummary
  ) extends zio.aws.schemas.model.SearchSchemaVersionSummary.ReadOnly {
    override val createdDate: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdDate())
        .map(value => value: __timestampIso8601)
    override val schemaVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaVersion())
      .map(value => value: __string)
    override val `type`: Optional[zio.aws.schemas.model.Type] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.schemas.model.Type.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.SearchSchemaVersionSummary
  ): zio.aws.schemas.model.SearchSchemaVersionSummary.ReadOnly = new Wrapper(
    impl
  )
}
