package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ExportSchemaResponse(
    content: Optional[__string] = Optional.Absent,
    schemaArn: Optional[__string] = Optional.Absent,
    schemaName: Optional[__string] = Optional.Absent,
    schemaVersion: Optional[__string] = Optional.Absent,
    `type`: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ExportSchemaResponse = {
    import ExportSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ExportSchemaResponse
      .builder()
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(schemaArn.map(value => value: java.lang.String))(
        _.schemaArn
      )
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ExportSchemaResponse.ReadOnly =
    zio.aws.schemas.model.ExportSchemaResponse.wrap(buildAwsValue())
}
object ExportSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ExportSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ExportSchemaResponse =
      zio.aws.schemas.model.ExportSchemaResponse(
        content.map(value => value),
        schemaArn.map(value => value),
        schemaName.map(value => value),
        schemaVersion.map(value => value),
        `type`.map(value => value)
      )
    def content: Optional[__string]
    def schemaArn: Optional[__string]
    def schemaName: Optional[__string]
    def schemaVersion: Optional[__string]
    def `type`: Optional[__string]
    def getContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("content", content)
    def getSchemaArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getSchemaName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ExportSchemaResponse
  ) extends zio.aws.schemas.model.ExportSchemaResponse.ReadOnly {
    override val content: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => value: __string)
    override val schemaArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaArn())
      .map(value => value: __string)
    override val schemaName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaName())
      .map(value => value: __string)
    override val schemaVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaVersion())
      .map(value => value: __string)
    override val `type`: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ExportSchemaResponse
  ): zio.aws.schemas.model.ExportSchemaResponse.ReadOnly = new Wrapper(impl)
}
