package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.Body
import scala.jdk.CollectionConverters._
final case class GetCodeBindingSourceResponse(
    body: Optional[Body] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceResponse = {
    import GetCodeBindingSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceResponse
      .builder()
      .optionallyWith(
        body.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.body)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.GetCodeBindingSourceResponse.ReadOnly =
    zio.aws.schemas.model.GetCodeBindingSourceResponse.wrap(buildAwsValue())
}
object GetCodeBindingSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.GetCodeBindingSourceResponse =
      zio.aws.schemas.model
        .GetCodeBindingSourceResponse(body.map(value => value))
    def body: Optional[Body]
    def getBody: ZIO[Any, AwsError, Body] =
      AwsError.unwrapOptionField("body", body)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceResponse
  ) extends zio.aws.schemas.model.GetCodeBindingSourceResponse.ReadOnly {
    override val body: Optional[Body] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value =>
        zio.aws.schemas.model.primitives
          .Body(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceResponse
  ): zio.aws.schemas.model.GetCodeBindingSourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
