package zio.aws.schemas.model
import scala.jdk.CollectionConverters._
sealed trait Type {
  def unwrap: software.amazon.awssdk.services.schemas.model.Type
}
object Type {
  def wrap(
      value: software.amazon.awssdk.services.schemas.model.Type
  ): zio.aws.schemas.model.Type = value match {
    case software.amazon.awssdk.services.schemas.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.schemas.model.Type.OPEN_API3 =>
      val r = OpenApi3
      r
    case software.amazon.awssdk.services.schemas.model.Type.JSON_SCHEMA_DRAFT4 =>
      val r = JSONSchemaDraft4
      r
  }
  case object unknownToSdkVersion extends zio.aws.schemas.model.Type {
    override def unwrap: software.amazon.awssdk.services.schemas.model.Type =
      software.amazon.awssdk.services.schemas.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object OpenApi3 extends zio.aws.schemas.model.Type {
    override def unwrap: software.amazon.awssdk.services.schemas.model.Type =
      software.amazon.awssdk.services.schemas.model.Type.OPEN_API3
  }
  case object JSONSchemaDraft4 extends zio.aws.schemas.model.Type {
    override def unwrap: software.amazon.awssdk.services.schemas.model.Type =
      software.amazon.awssdk.services.schemas.model.Type.JSON_SCHEMA_DRAFT4
  }
}
