package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class SchemaVersionSummary(
    schemaArn: Optional[__string] = Optional.Absent,
    schemaName: Optional[__string] = Optional.Absent,
    schemaVersion: Optional[__string] = Optional.Absent,
    `type`: Optional[zio.aws.schemas.model.Type] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.SchemaVersionSummary = {
    import SchemaVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.SchemaVersionSummary
      .builder()
      .optionallyWith(schemaArn.map(value => value: java.lang.String))(
        _.schemaArn
      )
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.SchemaVersionSummary.ReadOnly =
    zio.aws.schemas.model.SchemaVersionSummary.wrap(buildAwsValue())
}
object SchemaVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.SchemaVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.SchemaVersionSummary =
      zio.aws.schemas.model.SchemaVersionSummary(
        schemaArn.map(value => value),
        schemaName.map(value => value),
        schemaVersion.map(value => value),
        `type`.map(value => value)
      )
    def schemaArn: Optional[__string]
    def schemaName: Optional[__string]
    def schemaVersion: Optional[__string]
    def `type`: Optional[zio.aws.schemas.model.Type]
    def getSchemaArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getSchemaName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getType: ZIO[Any, AwsError, zio.aws.schemas.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.SchemaVersionSummary
  ) extends zio.aws.schemas.model.SchemaVersionSummary.ReadOnly {
    override val schemaArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaArn())
      .map(value => value: __string)
    override val schemaName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaName())
      .map(value => value: __string)
    override val schemaVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaVersion())
      .map(value => value: __string)
    override val `type`: Optional[zio.aws.schemas.model.Type] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.schemas.model.Type.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.SchemaVersionSummary
  ): zio.aws.schemas.model.SchemaVersionSummary.ReadOnly = new Wrapper(impl)
}
