package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyRequest(
    policy: __string,
    registryName: Optional[__string] = Optional.Absent,
    revisionId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest
      .builder()
      .policy(policy: java.lang.String)
      .optionallyWith(registryName.map(value => value: java.lang.String))(
        _.registryName
      )
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.schemas.model.PutResourcePolicyRequest.wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.PutResourcePolicyRequest =
      zio.aws.schemas.model.PutResourcePolicyRequest(
        policy,
        registryName.map(value => value),
        revisionId.map(value => value)
      )
    def policy: __string
    def registryName: Optional[__string]
    def revisionId: Optional[__string]
    def getPolicy: ZIO[Any, Nothing, __string] = ZIO.succeed(policy)
    def getRegistryName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryName", registryName)
    def getRevisionId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest
  ) extends zio.aws.schemas.model.PutResourcePolicyRequest.ReadOnly {
    override val policy: __string = impl.policy(): __string
    override val registryName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.registryName())
      .map(value => value: __string)
    override val revisionId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest
  ): zio.aws.schemas.model.PutResourcePolicyRequest.ReadOnly = new Wrapper(impl)
}
