package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListSchemasResponse(
    nextToken: Optional[__string] = Optional.Absent,
    schemas: Optional[Iterable[zio.aws.schemas.model.SchemaSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ListSchemasResponse = {
    import ListSchemasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ListSchemasResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        schemas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schemas)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ListSchemasResponse.ReadOnly =
    zio.aws.schemas.model.ListSchemasResponse.wrap(buildAwsValue())
}
object ListSchemasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ListSchemasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ListSchemasResponse =
      zio.aws.schemas.model.ListSchemasResponse(
        nextToken.map(value => value),
        schemas.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[__string]
    def schemas: Optional[List[zio.aws.schemas.model.SchemaSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSchemas: ZIO[Any, AwsError, List[
      zio.aws.schemas.model.SchemaSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("schemas", schemas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ListSchemasResponse
  ) extends zio.aws.schemas.model.ListSchemasResponse.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val schemas
        : Optional[List[zio.aws.schemas.model.SchemaSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.schemas.model.SchemaSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ListSchemasResponse
  ): zio.aws.schemas.model.ListSchemasResponse.ReadOnly = new Wrapper(impl)
}
