package zio.aws.schemas.model
import scala.jdk.CollectionConverters._
sealed trait CodeGenerationStatus {
  def unwrap: software.amazon.awssdk.services.schemas.model.CodeGenerationStatus
}
object CodeGenerationStatus {
  def wrap(
      value: software.amazon.awssdk.services.schemas.model.CodeGenerationStatus
  ): zio.aws.schemas.model.CodeGenerationStatus = value match {
    case software.amazon.awssdk.services.schemas.model.CodeGenerationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.schemas.model.CodeGenerationStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.schemas.model.CodeGenerationStatus.CREATE_COMPLETE =>
      val r = CREATE_COMPLETE
      r
    case software.amazon.awssdk.services.schemas.model.CodeGenerationStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.schemas.model.CodeGenerationStatus {
    override def unwrap
        : software.amazon.awssdk.services.schemas.model.CodeGenerationStatus =
      software.amazon.awssdk.services.schemas.model.CodeGenerationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.schemas.model.CodeGenerationStatus {
    override def unwrap
        : software.amazon.awssdk.services.schemas.model.CodeGenerationStatus =
      software.amazon.awssdk.services.schemas.model.CodeGenerationStatus.CREATE_IN_PROGRESS
  }
  case object CREATE_COMPLETE
      extends zio.aws.schemas.model.CodeGenerationStatus {
    override def unwrap
        : software.amazon.awssdk.services.schemas.model.CodeGenerationStatus =
      software.amazon.awssdk.services.schemas.model.CodeGenerationStatus.CREATE_COMPLETE
  }
  case object CREATE_FAILED extends zio.aws.schemas.model.CodeGenerationStatus {
    override def unwrap
        : software.amazon.awssdk.services.schemas.model.CodeGenerationStatus =
      software.amazon.awssdk.services.schemas.model.CodeGenerationStatus.CREATE_FAILED
  }
}
