package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.{
  __string,
  __stringMin0Max256,
  __stringMin1Max100000,
  __stringMin0Max36
}
import scala.jdk.CollectionConverters._
final case class UpdateSchemaRequest(
    clientTokenId: Optional[__stringMin0Max36] = Optional.Absent,
    content: Optional[__stringMin1Max100000] = Optional.Absent,
    description: Optional[__stringMin0Max256] = Optional.Absent,
    registryName: __string,
    schemaName: __string,
    `type`: Optional[zio.aws.schemas.model.Type] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest = {
    import UpdateSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest
      .builder()
      .optionallyWith(clientTokenId.map(value => value: java.lang.String))(
        _.clientTokenId
      )
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .registryName(registryName: java.lang.String)
      .schemaName(schemaName: java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.UpdateSchemaRequest.ReadOnly =
    zio.aws.schemas.model.UpdateSchemaRequest.wrap(buildAwsValue())
}
object UpdateSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.UpdateSchemaRequest =
      zio.aws.schemas.model.UpdateSchemaRequest(
        clientTokenId.map(value => value),
        content.map(value => value),
        description.map(value => value),
        registryName,
        schemaName,
        `type`.map(value => value)
      )
    def clientTokenId: Optional[__stringMin0Max36]
    def content: Optional[__stringMin1Max100000]
    def description: Optional[__stringMin0Max256]
    def registryName: __string
    def schemaName: __string
    def `type`: Optional[zio.aws.schemas.model.Type]
    def getClientTokenId: ZIO[Any, AwsError, __stringMin0Max36] =
      AwsError.unwrapOptionField("clientTokenId", clientTokenId)
    def getContent: ZIO[Any, AwsError, __stringMin1Max100000] =
      AwsError.unwrapOptionField("content", content)
    def getDescription: ZIO[Any, AwsError, __stringMin0Max256] =
      AwsError.unwrapOptionField("description", description)
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaName: ZIO[Any, Nothing, __string] = ZIO.succeed(schemaName)
    def getType: ZIO[Any, AwsError, zio.aws.schemas.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest
  ) extends zio.aws.schemas.model.UpdateSchemaRequest.ReadOnly {
    override val clientTokenId: Optional[__stringMin0Max36] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientTokenId())
        .map(value => value: __stringMin0Max36)
    override val content: Optional[__stringMin1Max100000] =
      zio.aws.core.internal
        .optionalFromNullable(impl.content())
        .map(value => value: __stringMin1Max100000)
    override val description: Optional[__stringMin0Max256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => value: __stringMin0Max256)
    override val registryName: __string = impl.registryName(): __string
    override val schemaName: __string = impl.schemaName(): __string
    override val `type`: Optional[zio.aws.schemas.model.Type] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.schemas.model.Type.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest
  ): zio.aws.schemas.model.UpdateSchemaRequest.ReadOnly = new Wrapper(impl)
}
