package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class RegistrySummary(
    registryArn: Optional[__string] = Optional.Absent,
    registryName: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.RegistrySummary = {
    import RegistrySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.RegistrySummary
      .builder()
      .optionallyWith(registryArn.map(value => value: java.lang.String))(
        _.registryArn
      )
      .optionallyWith(registryName.map(value => value: java.lang.String))(
        _.registryName
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.RegistrySummary.ReadOnly =
    zio.aws.schemas.model.RegistrySummary.wrap(buildAwsValue())
}
object RegistrySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.RegistrySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.RegistrySummary =
      zio.aws.schemas.model.RegistrySummary(
        registryArn.map(value => value),
        registryName.map(value => value),
        tags.map(value => value)
      )
    def registryArn: Optional[__string]
    def registryName: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def getRegistryArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryArn", registryArn)
    def getRegistryName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryName", registryName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.RegistrySummary
  ) extends zio.aws.schemas.model.RegistrySummary.ReadOnly {
    override val registryArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.registryArn())
      .map(value => value: __string)
    override val registryName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.registryName())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.RegistrySummary
  ): zio.aws.schemas.model.RegistrySummary.ReadOnly = new Wrapper(impl)
}
