package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.schemas.model.primitives.GetDiscoveredSchemaVersionItemInput
import scala.jdk.CollectionConverters._
final case class GetDiscoveredSchemaRequest(
    events: Iterable[GetDiscoveredSchemaVersionItemInput],
    `type`: zio.aws.schemas.model.Type
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaRequest = {
    import GetDiscoveredSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaRequest
      .builder()
      .events(events.map { item =>
        GetDiscoveredSchemaVersionItemInput.unwrap(item): java.lang.String
      }.asJavaCollection)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.GetDiscoveredSchemaRequest.ReadOnly =
    zio.aws.schemas.model.GetDiscoveredSchemaRequest.wrap(buildAwsValue())
}
object GetDiscoveredSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.GetDiscoveredSchemaRequest =
      zio.aws.schemas.model.GetDiscoveredSchemaRequest(events, `type`)
    def events: List[GetDiscoveredSchemaVersionItemInput]
    def `type`: zio.aws.schemas.model.Type
    def getEvents
        : ZIO[Any, Nothing, List[GetDiscoveredSchemaVersionItemInput]] =
      ZIO.succeed(events)
    def getType: ZIO[Any, Nothing, zio.aws.schemas.model.Type] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaRequest
  ) extends zio.aws.schemas.model.GetDiscoveredSchemaRequest.ReadOnly {
    override val events: List[GetDiscoveredSchemaVersionItemInput] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.schemas.model.primitives
          .GetDiscoveredSchemaVersionItemInput(item)
      }
      .toList
    override val `type`: zio.aws.schemas.model.Type =
      zio.aws.schemas.model.Type.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaRequest
  ): zio.aws.schemas.model.GetDiscoveredSchemaRequest.ReadOnly = new Wrapper(
    impl
  )
}
