package zio.aws.schemas
import zio.aws.schemas.model.DescribeDiscovererResponse.ReadOnly
import zio.aws.schemas.model.{
  ListDiscoverersRequest,
  DescribeRegistryRequest,
  CreateRegistryRequest,
  DescribeSchemaRequest,
  PutResourcePolicyRequest,
  ListSchemasRequest,
  ListTagsForResourceRequest,
  CreateDiscovererRequest,
  SearchSchemasRequest,
  CreateSchemaRequest,
  UpdateRegistryRequest,
  DeleteRegistryRequest,
  StopDiscovererRequest,
  ListRegistriesRequest,
  DeleteDiscovererRequest,
  DescribeDiscovererRequest,
  GetCodeBindingSourceRequest,
  UpdateSchemaRequest,
  DeleteSchemaVersionRequest,
  DeleteResourcePolicyRequest,
  UntagResourceRequest,
  ExportSchemaRequest,
  PutCodeBindingRequest,
  GetDiscoveredSchemaRequest,
  ListSchemaVersionsRequest,
  DescribeCodeBindingRequest,
  DeleteSchemaRequest,
  GetResourcePolicyRequest,
  UpdateDiscovererRequest,
  StartDiscovererRequest,
  TagResourceRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.schemas.SchemasAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object SchemasMock extends Mock[Schemas] {
  object StopDiscoverer
      extends Effect[
        StopDiscovererRequest,
        AwsError,
        zio.aws.schemas.model.StopDiscovererResponse.ReadOnly
      ]
  object CreateRegistry
      extends Effect[
        CreateRegistryRequest,
        AwsError,
        zio.aws.schemas.model.CreateRegistryResponse.ReadOnly
      ]
  object SearchSchemas
      extends Stream[
        SearchSchemasRequest,
        AwsError,
        zio.aws.schemas.model.SearchSchemaSummary.ReadOnly
      ]
  object SearchSchemasPaginated
      extends Effect[
        SearchSchemasRequest,
        AwsError,
        zio.aws.schemas.model.SearchSchemasResponse.ReadOnly
      ]
  object ListRegistries
      extends Stream[
        ListRegistriesRequest,
        AwsError,
        zio.aws.schemas.model.RegistrySummary.ReadOnly
      ]
  object ListRegistriesPaginated
      extends Effect[
        ListRegistriesRequest,
        AwsError,
        zio.aws.schemas.model.ListRegistriesResponse.ReadOnly
      ]
  object StartDiscoverer
      extends Effect[
        StartDiscovererRequest,
        AwsError,
        zio.aws.schemas.model.StartDiscovererResponse.ReadOnly
      ]
  object GetDiscoveredSchema
      extends Effect[
        GetDiscoveredSchemaRequest,
        AwsError,
        zio.aws.schemas.model.GetDiscoveredSchemaResponse.ReadOnly
      ]
  object UpdateDiscoverer
      extends Effect[
        UpdateDiscovererRequest,
        AwsError,
        zio.aws.schemas.model.UpdateDiscovererResponse.ReadOnly
      ]
  object PutResourcePolicy
      extends Effect[
        PutResourcePolicyRequest,
        AwsError,
        zio.aws.schemas.model.PutResourcePolicyResponse.ReadOnly
      ]
  object DescribeSchema
      extends Effect[
        DescribeSchemaRequest,
        AwsError,
        zio.aws.schemas.model.DescribeSchemaResponse.ReadOnly
      ]
  object DescribeRegistry
      extends Effect[
        DescribeRegistryRequest,
        AwsError,
        zio.aws.schemas.model.DescribeRegistryResponse.ReadOnly
      ]
  object DescribeCodeBinding
      extends Effect[
        DescribeCodeBindingRequest,
        AwsError,
        zio.aws.schemas.model.DescribeCodeBindingResponse.ReadOnly
      ]
  object DeleteSchemaVersion
      extends Effect[DeleteSchemaVersionRequest, AwsError, Unit]
  object UpdateSchema
      extends Effect[
        UpdateSchemaRequest,
        AwsError,
        zio.aws.schemas.model.UpdateSchemaResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object DeleteRegistry extends Effect[DeleteRegistryRequest, AwsError, Unit]
  object DeleteResourcePolicy
      extends Effect[DeleteResourcePolicyRequest, AwsError, Unit]
  object ExportSchema
      extends Effect[
        ExportSchemaRequest,
        AwsError,
        zio.aws.schemas.model.ExportSchemaResponse.ReadOnly
      ]
  object DeleteDiscoverer
      extends Effect[DeleteDiscovererRequest, AwsError, Unit]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.schemas.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object CreateSchema
      extends Effect[
        CreateSchemaRequest,
        AwsError,
        zio.aws.schemas.model.CreateSchemaResponse.ReadOnly
      ]
  object GetCodeBindingSource
      extends Effect[
        GetCodeBindingSourceRequest,
        AwsError,
        zio.aws.schemas.model.GetCodeBindingSourceResponse.ReadOnly
      ]
  object DeleteSchema extends Effect[DeleteSchemaRequest, AwsError, Unit]
  object GetResourcePolicy
      extends Effect[
        GetResourcePolicyRequest,
        AwsError,
        zio.aws.schemas.model.GetResourcePolicyResponse.ReadOnly
      ]
  object ListSchemaVersions
      extends Stream[
        ListSchemaVersionsRequest,
        AwsError,
        zio.aws.schemas.model.SchemaVersionSummary.ReadOnly
      ]
  object ListSchemaVersionsPaginated
      extends Effect[
        ListSchemaVersionsRequest,
        AwsError,
        zio.aws.schemas.model.ListSchemaVersionsResponse.ReadOnly
      ]
  object UpdateRegistry
      extends Effect[
        UpdateRegistryRequest,
        AwsError,
        zio.aws.schemas.model.UpdateRegistryResponse.ReadOnly
      ]
  object DescribeDiscoverer
      extends Effect[DescribeDiscovererRequest, AwsError, ReadOnly]
  object ListSchemas
      extends Stream[
        ListSchemasRequest,
        AwsError,
        zio.aws.schemas.model.SchemaSummary.ReadOnly
      ]
  object ListSchemasPaginated
      extends Effect[
        ListSchemasRequest,
        AwsError,
        zio.aws.schemas.model.ListSchemasResponse.ReadOnly
      ]
  object PutCodeBinding
      extends Effect[
        PutCodeBindingRequest,
        AwsError,
        zio.aws.schemas.model.PutCodeBindingResponse.ReadOnly
      ]
  object ListDiscoverers
      extends Stream[
        ListDiscoverersRequest,
        AwsError,
        zio.aws.schemas.model.DiscovererSummary.ReadOnly
      ]
  object ListDiscoverersPaginated
      extends Effect[
        ListDiscoverersRequest,
        AwsError,
        zio.aws.schemas.model.ListDiscoverersResponse.ReadOnly
      ]
  object CreateDiscoverer
      extends Effect[
        CreateDiscovererRequest,
        AwsError,
        zio.aws.schemas.model.CreateDiscovererResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Schemas] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Schemas] { rts =>
        zio.ZIO.succeed {
          new Schemas {
            val api: SchemasAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Schemas = this
            def stopDiscoverer(request: StopDiscovererRequest): IO[
              AwsError,
              zio.aws.schemas.model.StopDiscovererResponse.ReadOnly
            ] = proxy(StopDiscoverer, request)
            def createRegistry(request: CreateRegistryRequest): IO[
              AwsError,
              zio.aws.schemas.model.CreateRegistryResponse.ReadOnly
            ] = proxy(CreateRegistry, request)
            def searchSchemas(request: SearchSchemasRequest): ZStream[
              Any,
              AwsError,
              zio.aws.schemas.model.SearchSchemaSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchSchemas, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchSchemasPaginated(request: SearchSchemasRequest): IO[
              AwsError,
              zio.aws.schemas.model.SearchSchemasResponse.ReadOnly
            ] = proxy(SearchSchemasPaginated, request)
            def listRegistries(request: ListRegistriesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.schemas.model.RegistrySummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRegistries, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRegistriesPaginated(request: ListRegistriesRequest): IO[
              AwsError,
              zio.aws.schemas.model.ListRegistriesResponse.ReadOnly
            ] = proxy(ListRegistriesPaginated, request)
            def startDiscoverer(request: StartDiscovererRequest): IO[
              AwsError,
              zio.aws.schemas.model.StartDiscovererResponse.ReadOnly
            ] = proxy(StartDiscoverer, request)
            def getDiscoveredSchema(request: GetDiscoveredSchemaRequest): IO[
              AwsError,
              zio.aws.schemas.model.GetDiscoveredSchemaResponse.ReadOnly
            ] = proxy(GetDiscoveredSchema, request)
            def updateDiscoverer(request: UpdateDiscovererRequest): IO[
              AwsError,
              zio.aws.schemas.model.UpdateDiscovererResponse.ReadOnly
            ] = proxy(UpdateDiscoverer, request)
            def putResourcePolicy(request: PutResourcePolicyRequest): IO[
              AwsError,
              zio.aws.schemas.model.PutResourcePolicyResponse.ReadOnly
            ] = proxy(PutResourcePolicy, request)
            def describeSchema(request: DescribeSchemaRequest): IO[
              AwsError,
              zio.aws.schemas.model.DescribeSchemaResponse.ReadOnly
            ] = proxy(DescribeSchema, request)
            def describeRegistry(request: DescribeRegistryRequest): IO[
              AwsError,
              zio.aws.schemas.model.DescribeRegistryResponse.ReadOnly
            ] = proxy(DescribeRegistry, request)
            def describeCodeBinding(request: DescribeCodeBindingRequest): IO[
              AwsError,
              zio.aws.schemas.model.DescribeCodeBindingResponse.ReadOnly
            ] = proxy(DescribeCodeBinding, request)
            def deleteSchemaVersion(
                request: DeleteSchemaVersionRequest
            ): IO[AwsError, Unit] = proxy(DeleteSchemaVersion, request)
            def updateSchema(request: UpdateSchemaRequest): IO[
              AwsError,
              zio.aws.schemas.model.UpdateSchemaResponse.ReadOnly
            ] = proxy(UpdateSchema, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def deleteRegistry(
                request: DeleteRegistryRequest
            ): IO[AwsError, Unit] = proxy(DeleteRegistry, request)
            def deleteResourcePolicy(
                request: DeleteResourcePolicyRequest
            ): IO[AwsError, Unit] = proxy(DeleteResourcePolicy, request)
            def exportSchema(request: ExportSchemaRequest): IO[
              AwsError,
              zio.aws.schemas.model.ExportSchemaResponse.ReadOnly
            ] = proxy(ExportSchema, request)
            def deleteDiscoverer(
                request: DeleteDiscovererRequest
            ): IO[AwsError, Unit] = proxy(DeleteDiscoverer, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.schemas.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def createSchema(request: CreateSchemaRequest): IO[
              AwsError,
              zio.aws.schemas.model.CreateSchemaResponse.ReadOnly
            ] = proxy(CreateSchema, request)
            def getCodeBindingSource(request: GetCodeBindingSourceRequest): IO[
              AwsError,
              zio.aws.schemas.model.GetCodeBindingSourceResponse.ReadOnly
            ] = proxy(GetCodeBindingSource, request)
            def deleteSchema(request: DeleteSchemaRequest): IO[AwsError, Unit] =
              proxy(DeleteSchema, request)
            def getResourcePolicy(request: GetResourcePolicyRequest): IO[
              AwsError,
              zio.aws.schemas.model.GetResourcePolicyResponse.ReadOnly
            ] = proxy(GetResourcePolicy, request)
            def listSchemaVersions(request: ListSchemaVersionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.schemas.model.SchemaVersionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSchemaVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSchemaVersionsPaginated(
                request: ListSchemaVersionsRequest
            ): IO[
              AwsError,
              zio.aws.schemas.model.ListSchemaVersionsResponse.ReadOnly
            ] = proxy(ListSchemaVersionsPaginated, request)
            def updateRegistry(request: UpdateRegistryRequest): IO[
              AwsError,
              zio.aws.schemas.model.UpdateRegistryResponse.ReadOnly
            ] = proxy(UpdateRegistry, request)
            def describeDiscoverer(
                request: DescribeDiscovererRequest
            ): IO[AwsError, ReadOnly] = proxy(DescribeDiscoverer, request)
            def listSchemas(request: ListSchemasRequest): ZStream[
              Any,
              AwsError,
              zio.aws.schemas.model.SchemaSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSchemas, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSchemasPaginated(request: ListSchemasRequest): IO[
              AwsError,
              zio.aws.schemas.model.ListSchemasResponse.ReadOnly
            ] = proxy(ListSchemasPaginated, request)
            def putCodeBinding(request: PutCodeBindingRequest): IO[
              AwsError,
              zio.aws.schemas.model.PutCodeBindingResponse.ReadOnly
            ] = proxy(PutCodeBinding, request)
            def listDiscoverers(request: ListDiscoverersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.schemas.model.DiscovererSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDiscoverers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDiscoverersPaginated(request: ListDiscoverersRequest): IO[
              AwsError,
              zio.aws.schemas.model.ListDiscoverersResponse.ReadOnly
            ] = proxy(ListDiscoverersPaginated, request)
            def createDiscoverer(request: CreateDiscovererRequest): IO[
              AwsError,
              zio.aws.schemas.model.CreateDiscovererResponse.ReadOnly
            ] = proxy(CreateDiscoverer, request)
          }
        }
      }
    }
  }
}
