package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class GetResourcePolicyRequest(
    registryName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.GetResourcePolicyRequest = {
    import GetResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.GetResourcePolicyRequest
      .builder()
      .optionallyWith(registryName.map(value => value: java.lang.String))(
        _.registryName
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.GetResourcePolicyRequest.ReadOnly =
    zio.aws.schemas.model.GetResourcePolicyRequest.wrap(buildAwsValue())
}
object GetResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.GetResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.GetResourcePolicyRequest =
      zio.aws.schemas.model
        .GetResourcePolicyRequest(registryName.map(value => value))
    def registryName: Optional[__string]
    def getRegistryName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryName", registryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.GetResourcePolicyRequest
  ) extends zio.aws.schemas.model.GetResourcePolicyRequest.ReadOnly {
    override val registryName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.registryName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.GetResourcePolicyRequest
  ): zio.aws.schemas.model.GetResourcePolicyRequest.ReadOnly = new Wrapper(impl)
}
