package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class SearchSchemasResponse(
    nextToken: Optional[__string] = Optional.Absent,
    schemas: Optional[Iterable[zio.aws.schemas.model.SearchSchemaSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.SearchSchemasResponse = {
    import SearchSchemasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.SearchSchemasResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        schemas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schemas)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.SearchSchemasResponse.ReadOnly =
    zio.aws.schemas.model.SearchSchemasResponse.wrap(buildAwsValue())
}
object SearchSchemasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.SearchSchemasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.SearchSchemasResponse =
      zio.aws.schemas.model.SearchSchemasResponse(
        nextToken.map(value => value),
        schemas.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[__string]
    def schemas
        : Optional[List[zio.aws.schemas.model.SearchSchemaSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSchemas: ZIO[Any, AwsError, List[
      zio.aws.schemas.model.SearchSchemaSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("schemas", schemas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.SearchSchemasResponse
  ) extends zio.aws.schemas.model.SearchSchemasResponse.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val schemas
        : Optional[List[zio.aws.schemas.model.SearchSchemaSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.schemas.model.SearchSchemaSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.SearchSchemasResponse
  ): zio.aws.schemas.model.SearchSchemasResponse.ReadOnly = new Wrapper(impl)
}
