package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListDiscoverersResponse(
    discoverers: Optional[Iterable[zio.aws.schemas.model.DiscovererSummary]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse = {
    import ListDiscoverersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse
      .builder()
      .optionallyWith(
        discoverers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.discoverers)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ListDiscoverersResponse.ReadOnly =
    zio.aws.schemas.model.ListDiscoverersResponse.wrap(buildAwsValue())
}
object ListDiscoverersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ListDiscoverersResponse =
      zio.aws.schemas.model.ListDiscoverersResponse(
        discoverers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def discoverers
        : Optional[List[zio.aws.schemas.model.DiscovererSummary.ReadOnly]]
    def nextToken: Optional[__string]
    def getDiscoverers: ZIO[Any, AwsError, List[
      zio.aws.schemas.model.DiscovererSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("discoverers", discoverers)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse
  ) extends zio.aws.schemas.model.ListDiscoverersResponse.ReadOnly {
    override val discoverers
        : Optional[List[zio.aws.schemas.model.DiscovererSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.discoverers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.schemas.model.DiscovererSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse
  ): zio.aws.schemas.model.ListDiscoverersResponse.ReadOnly = new Wrapper(impl)
}
