package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.{
  __string,
  __stringMin0Max256,
  __stringMin1Max100000
}
import scala.jdk.CollectionConverters._
final case class CreateSchemaRequest(
    content: __stringMin1Max100000,
    description: Optional[__stringMin0Max256] = Optional.Absent,
    registryName: __string,
    schemaName: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    `type`: zio.aws.schemas.model.Type
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.CreateSchemaRequest = {
    import CreateSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.CreateSchemaRequest
      .builder()
      .content(content: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .registryName(registryName: java.lang.String)
      .schemaName(schemaName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.CreateSchemaRequest.ReadOnly =
    zio.aws.schemas.model.CreateSchemaRequest.wrap(buildAwsValue())
}
object CreateSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.CreateSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.CreateSchemaRequest =
      zio.aws.schemas.model.CreateSchemaRequest(
        content,
        description.map(value => value),
        registryName,
        schemaName,
        tags.map(value => value),
        `type`
      )
    def content: __stringMin1Max100000
    def description: Optional[__stringMin0Max256]
    def registryName: __string
    def schemaName: __string
    def tags: Optional[Map[__string, __string]]
    def `type`: zio.aws.schemas.model.Type
    def getContent: ZIO[Any, Nothing, __stringMin1Max100000] =
      ZIO.succeed(content)
    def getDescription: ZIO[Any, AwsError, __stringMin0Max256] =
      AwsError.unwrapOptionField("description", description)
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaName: ZIO[Any, Nothing, __string] = ZIO.succeed(schemaName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, Nothing, zio.aws.schemas.model.Type] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.CreateSchemaRequest
  ) extends zio.aws.schemas.model.CreateSchemaRequest.ReadOnly {
    override val content: __stringMin1Max100000 =
      impl.content(): __stringMin1Max100000
    override val description: Optional[__stringMin0Max256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => value: __stringMin0Max256)
    override val registryName: __string = impl.registryName(): __string
    override val schemaName: __string = impl.schemaName(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val `type`: zio.aws.schemas.model.Type =
      zio.aws.schemas.model.Type.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.CreateSchemaRequest
  ): zio.aws.schemas.model.CreateSchemaRequest.ReadOnly = new Wrapper(impl)
}
