package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.{__string, __stringMin0Max256}
import scala.jdk.CollectionConverters._
final case class CreateRegistryRequest(
    description: Optional[__stringMin0Max256] = Optional.Absent,
    registryName: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.CreateRegistryRequest = {
    import CreateRegistryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.CreateRegistryRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .registryName(registryName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.CreateRegistryRequest.ReadOnly =
    zio.aws.schemas.model.CreateRegistryRequest.wrap(buildAwsValue())
}
object CreateRegistryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.CreateRegistryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.CreateRegistryRequest =
      zio.aws.schemas.model.CreateRegistryRequest(
        description.map(value => value),
        registryName,
        tags.map(value => value)
      )
    def description: Optional[__stringMin0Max256]
    def registryName: __string
    def tags: Optional[Map[__string, __string]]
    def getDescription: ZIO[Any, AwsError, __stringMin0Max256] =
      AwsError.unwrapOptionField("description", description)
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.CreateRegistryRequest
  ) extends zio.aws.schemas.model.CreateRegistryRequest.ReadOnly {
    override val description: Optional[__stringMin0Max256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => value: __stringMin0Max256)
    override val registryName: __string = impl.registryName(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.CreateRegistryRequest
  ): zio.aws.schemas.model.CreateRegistryRequest.ReadOnly = new Wrapper(impl)
}
