package zio.aws.schemas.model
import zio.aws.schemas.model.primitives.{__string, __integer}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSchemasRequest(
    limit: Optional[__integer] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    registryName: __string,
    schemaNamePrefix: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ListSchemasRequest = {
    import ListSchemasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ListSchemasRequest
      .builder()
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .registryName(registryName: java.lang.String)
      .optionallyWith(schemaNamePrefix.map(value => value: java.lang.String))(
        _.schemaNamePrefix
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ListSchemasRequest.ReadOnly =
    zio.aws.schemas.model.ListSchemasRequest.wrap(buildAwsValue())
}
object ListSchemasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ListSchemasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ListSchemasRequest =
      zio.aws.schemas.model.ListSchemasRequest(
        limit.map(value => value),
        nextToken.map(value => value),
        registryName,
        schemaNamePrefix.map(value => value)
      )
    def limit: Optional[__integer]
    def nextToken: Optional[__string]
    def registryName: __string
    def schemaNamePrefix: Optional[__string]
    def getLimit: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaNamePrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaNamePrefix", schemaNamePrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ListSchemasRequest
  ) extends zio.aws.schemas.model.ListSchemasRequest.ReadOnly {
    override val limit: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: __integer)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val registryName: __string = impl.registryName(): __string
    override val schemaNamePrefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaNamePrefix())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ListSchemasRequest
  ): zio.aws.schemas.model.ListSchemasRequest.ReadOnly = new Wrapper(impl)
}
