package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DescribeRegistryResponse(
    description: Optional[__string] = Optional.Absent,
    registryArn: Optional[__string] = Optional.Absent,
    registryName: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse = {
    import DescribeRegistryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(registryArn.map(value => value: java.lang.String))(
        _.registryArn
      )
      .optionallyWith(registryName.map(value => value: java.lang.String))(
        _.registryName
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.DescribeRegistryResponse.ReadOnly =
    zio.aws.schemas.model.DescribeRegistryResponse.wrap(buildAwsValue())
}
object DescribeRegistryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.DescribeRegistryResponse =
      zio.aws.schemas.model.DescribeRegistryResponse(
        description.map(value => value),
        registryArn.map(value => value),
        registryName.map(value => value),
        tags.map(value => value)
      )
    def description: Optional[__string]
    def registryArn: Optional[__string]
    def registryName: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getRegistryArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryArn", registryArn)
    def getRegistryName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryName", registryName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse
  ) extends zio.aws.schemas.model.DescribeRegistryResponse.ReadOnly {
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val registryArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.registryArn())
      .map(value => value: __string)
    override val registryName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.registryName())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse
  ): zio.aws.schemas.model.DescribeRegistryResponse.ReadOnly = new Wrapper(impl)
}
