package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ExportSchemaRequest(
    registryName: __string,
    schemaName: __string,
    schemaVersion: Optional[__string] = Optional.Absent,
    `type`: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ExportSchemaRequest = {
    import ExportSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ExportSchemaRequest
      .builder()
      .registryName(registryName: java.lang.String)
      .schemaName(schemaName: java.lang.String)
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ExportSchemaRequest.ReadOnly =
    zio.aws.schemas.model.ExportSchemaRequest.wrap(buildAwsValue())
}
object ExportSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ExportSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ExportSchemaRequest =
      zio.aws.schemas.model.ExportSchemaRequest(
        registryName,
        schemaName,
        schemaVersion.map(value => value),
        `type`
      )
    def registryName: __string
    def schemaName: __string
    def schemaVersion: Optional[__string]
    def `type`: __string
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaName: ZIO[Any, Nothing, __string] = ZIO.succeed(schemaName)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getType: ZIO[Any, Nothing, __string] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ExportSchemaRequest
  ) extends zio.aws.schemas.model.ExportSchemaRequest.ReadOnly {
    override val registryName: __string = impl.registryName(): __string
    override val schemaName: __string = impl.schemaName(): __string
    override val schemaVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaVersion())
      .map(value => value: __string)
    override val `type`: __string = impl.`type`(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ExportSchemaRequest
  ): zio.aws.schemas.model.ExportSchemaRequest.ReadOnly = new Wrapper(impl)
}
