package zio.aws.schemas.model
import zio.aws.schemas.model.primitives.{__integer, __string}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDiscoverersRequest(
    discovererIdPrefix: Optional[__string] = Optional.Absent,
    limit: Optional[__integer] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    sourceArnPrefix: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest = {
    import ListDiscoverersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest
      .builder()
      .optionallyWith(discovererIdPrefix.map(value => value: java.lang.String))(
        _.discovererIdPrefix
      )
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(sourceArnPrefix.map(value => value: java.lang.String))(
        _.sourceArnPrefix
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ListDiscoverersRequest.ReadOnly =
    zio.aws.schemas.model.ListDiscoverersRequest.wrap(buildAwsValue())
}
object ListDiscoverersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ListDiscoverersRequest =
      zio.aws.schemas.model.ListDiscoverersRequest(
        discovererIdPrefix.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value),
        sourceArnPrefix.map(value => value)
      )
    def discovererIdPrefix: Optional[__string]
    def limit: Optional[__integer]
    def nextToken: Optional[__string]
    def sourceArnPrefix: Optional[__string]
    def getDiscovererIdPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("discovererIdPrefix", discovererIdPrefix)
    def getLimit: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSourceArnPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceArnPrefix", sourceArnPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest
  ) extends zio.aws.schemas.model.ListDiscoverersRequest.ReadOnly {
    override val discovererIdPrefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.discovererIdPrefix())
      .map(value => value: __string)
    override val limit: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: __integer)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val sourceArnPrefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArnPrefix())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest
  ): zio.aws.schemas.model.ListDiscoverersRequest.ReadOnly = new Wrapper(impl)
}
