package zio.aws.schemas.model
import zio.aws.schemas.model.primitives.{__timestampIso8601, __string}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeSchemaResponse(
    content: Optional[__string] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    lastModified: Optional[__timestampIso8601] = Optional.Absent,
    schemaArn: Optional[__string] = Optional.Absent,
    schemaName: Optional[__string] = Optional.Absent,
    schemaVersion: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    `type`: Optional[__string] = Optional.Absent,
    versionCreatedDate: Optional[__timestampIso8601] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.DescribeSchemaResponse = {
    import DescribeSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.DescribeSchemaResponse
      .builder()
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .optionallyWith(schemaArn.map(value => value: java.lang.String))(
        _.schemaArn
      )
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(versionCreatedDate.map(value => value: Instant))(
        _.versionCreatedDate
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.DescribeSchemaResponse.ReadOnly =
    zio.aws.schemas.model.DescribeSchemaResponse.wrap(buildAwsValue())
}
object DescribeSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.DescribeSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.DescribeSchemaResponse =
      zio.aws.schemas.model.DescribeSchemaResponse(
        content.map(value => value),
        description.map(value => value),
        lastModified.map(value => value),
        schemaArn.map(value => value),
        schemaName.map(value => value),
        schemaVersion.map(value => value),
        tags.map(value => value),
        `type`.map(value => value),
        versionCreatedDate.map(value => value)
      )
    def content: Optional[__string]
    def description: Optional[__string]
    def lastModified: Optional[__timestampIso8601]
    def schemaArn: Optional[__string]
    def schemaName: Optional[__string]
    def schemaVersion: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def `type`: Optional[__string]
    def versionCreatedDate: Optional[__timestampIso8601]
    def getContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("content", content)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getLastModified: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getSchemaArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getSchemaName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("type", `type`)
    def getVersionCreatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("versionCreatedDate", versionCreatedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.DescribeSchemaResponse
  ) extends zio.aws.schemas.model.DescribeSchemaResponse.ReadOnly {
    override val content: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => value: __string)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val lastModified: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModified())
        .map(value => value: __timestampIso8601)
    override val schemaArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaArn())
      .map(value => value: __string)
    override val schemaName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaName())
      .map(value => value: __string)
    override val schemaVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaVersion())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val `type`: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: __string)
    override val versionCreatedDate: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionCreatedDate())
        .map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.DescribeSchemaResponse
  ): zio.aws.schemas.model.DescribeSchemaResponse.ReadOnly = new Wrapper(impl)
}
