package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListRegistriesResponse(
    nextToken: Optional[__string] = Optional.Absent,
    registries: Optional[Iterable[zio.aws.schemas.model.RegistrySummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ListRegistriesResponse = {
    import ListRegistriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ListRegistriesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        registries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.registries)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ListRegistriesResponse.ReadOnly =
    zio.aws.schemas.model.ListRegistriesResponse.wrap(buildAwsValue())
}
object ListRegistriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ListRegistriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ListRegistriesResponse =
      zio.aws.schemas.model.ListRegistriesResponse(
        nextToken.map(value => value),
        registries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[__string]
    def registries
        : Optional[List[zio.aws.schemas.model.RegistrySummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegistries: ZIO[Any, AwsError, List[
      zio.aws.schemas.model.RegistrySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("registries", registries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ListRegistriesResponse
  ) extends zio.aws.schemas.model.ListRegistriesResponse.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val registries
        : Optional[List[zio.aws.schemas.model.RegistrySummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.schemas.model.RegistrySummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ListRegistriesResponse
  ): zio.aws.schemas.model.ListRegistriesResponse.ReadOnly = new Wrapper(impl)
}
