package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class SearchSchemaSummary(
    registryName: Optional[__string] = Optional.Absent,
    schemaArn: Optional[__string] = Optional.Absent,
    schemaName: Optional[__string] = Optional.Absent,
    schemaVersions: Optional[
      Iterable[zio.aws.schemas.model.SearchSchemaVersionSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.SearchSchemaSummary = {
    import SearchSchemaSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.SearchSchemaSummary
      .builder()
      .optionallyWith(registryName.map(value => value: java.lang.String))(
        _.registryName
      )
      .optionallyWith(schemaArn.map(value => value: java.lang.String))(
        _.schemaArn
      )
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(
        schemaVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schemaVersions)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.SearchSchemaSummary.ReadOnly =
    zio.aws.schemas.model.SearchSchemaSummary.wrap(buildAwsValue())
}
object SearchSchemaSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.SearchSchemaSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.SearchSchemaSummary =
      zio.aws.schemas.model.SearchSchemaSummary(
        registryName.map(value => value),
        schemaArn.map(value => value),
        schemaName.map(value => value),
        schemaVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def registryName: Optional[__string]
    def schemaArn: Optional[__string]
    def schemaName: Optional[__string]
    def schemaVersions: Optional[
      List[zio.aws.schemas.model.SearchSchemaVersionSummary.ReadOnly]
    ]
    def getRegistryName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryName", registryName)
    def getSchemaArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getSchemaName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getSchemaVersions: ZIO[Any, AwsError, List[
      zio.aws.schemas.model.SearchSchemaVersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("schemaVersions", schemaVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.SearchSchemaSummary
  ) extends zio.aws.schemas.model.SearchSchemaSummary.ReadOnly {
    override val registryName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.registryName())
      .map(value => value: __string)
    override val schemaArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaArn())
      .map(value => value: __string)
    override val schemaName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaName())
      .map(value => value: __string)
    override val schemaVersions: Optional[
      List[zio.aws.schemas.model.SearchSchemaVersionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.schemas.model.SearchSchemaVersionSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.SearchSchemaSummary
  ): zio.aws.schemas.model.SearchSchemaSummary.ReadOnly = new Wrapper(impl)
}
