package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.schemas.model.primitives.{__string, __timestampIso8601}
import scala.jdk.CollectionConverters._
final case class DescribeCodeBindingResponse(
    creationDate: Option[__timestampIso8601] = None,
    lastModified: Option[__timestampIso8601] = None,
    schemaVersion: Option[__string] = None,
    status: Option[zio.aws.schemas.model.CodeGenerationStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.DescribeCodeBindingResponse = {
    import DescribeCodeBindingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.DescribeCodeBindingResponse
      .builder()
      .optionallyWith(creationDate.map(value => value: Instant))(_.creationDate)
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.DescribeCodeBindingResponse.ReadOnly =
    zio.aws.schemas.model.DescribeCodeBindingResponse.wrap(buildAwsValue())
}
object DescribeCodeBindingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.DescribeCodeBindingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.DescribeCodeBindingResponse =
      zio.aws.schemas.model.DescribeCodeBindingResponse(
        creationDate.map(value => value),
        lastModified.map(value => value),
        schemaVersion.map(value => value),
        status.map(value => value)
      )
    def creationDate: Option[__timestampIso8601]
    def lastModified: Option[__timestampIso8601]
    def schemaVersion: Option[__string]
    def status: Option[zio.aws.schemas.model.CodeGenerationStatus]
    def getCreationDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModified: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.schemas.model.CodeGenerationStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.DescribeCodeBindingResponse
  ) extends zio.aws.schemas.model.DescribeCodeBindingResponse.ReadOnly {
    override val creationDate: Option[__timestampIso8601] =
      scala.Option(impl.creationDate()).map(value => value: __timestampIso8601)
    override val lastModified: Option[__timestampIso8601] =
      scala.Option(impl.lastModified()).map(value => value: __timestampIso8601)
    override val schemaVersion: Option[__string] =
      scala.Option(impl.schemaVersion()).map(value => value: __string)
    override val status: Option[zio.aws.schemas.model.CodeGenerationStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.schemas.model.CodeGenerationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.DescribeCodeBindingResponse
  ): zio.aws.schemas.model.DescribeCodeBindingResponse.ReadOnly = new Wrapper(
    impl
  )
}
