package zio.aws.schemas.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.{__string, __integer}
import scala.jdk.CollectionConverters._
final case class ListSchemaVersionsRequest(
    limit: Option[__integer] = None,
    nextToken: Option[__string] = None,
    registryName: __string,
    schemaName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest = {
    import ListSchemaVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest
      .builder()
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .registryName(registryName: java.lang.String)
      .schemaName(schemaName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ListSchemaVersionsRequest.ReadOnly =
    zio.aws.schemas.model.ListSchemaVersionsRequest.wrap(buildAwsValue())
}
object ListSchemaVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ListSchemaVersionsRequest =
      zio.aws.schemas.model.ListSchemaVersionsRequest(
        limit.map(value => value),
        nextToken.map(value => value),
        registryName,
        schemaName
      )
    def limit: Option[__integer]
    def nextToken: Option[__string]
    def registryName: __string
    def schemaName: __string
    def getLimit: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaName: ZIO[Any, Nothing, __string] = ZIO.succeed(schemaName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest
  ) extends zio.aws.schemas.model.ListSchemaVersionsRequest.ReadOnly {
    override val limit: Option[__integer] =
      scala.Option(impl.limit()).map(value => value: __integer)
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val registryName: __string = impl.registryName(): __string
    override val schemaName: __string = impl.schemaName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest
  ): zio.aws.schemas.model.ListSchemaVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
