package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.{
  __boolean,
  __string,
  __stringMin0Max256
}
import scala.jdk.CollectionConverters._
final case class UpdateDiscovererRequest(
    description: Option[__stringMin0Max256] = None,
    discovererId: __string,
    crossAccount: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.UpdateDiscovererRequest = {
    import UpdateDiscovererRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.UpdateDiscovererRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .discovererId(discovererId: java.lang.String)
      .optionallyWith(crossAccount.map(value => value: java.lang.Boolean))(
        _.crossAccount
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.UpdateDiscovererRequest.ReadOnly =
    zio.aws.schemas.model.UpdateDiscovererRequest.wrap(buildAwsValue())
}
object UpdateDiscovererRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.UpdateDiscovererRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.UpdateDiscovererRequest =
      zio.aws.schemas.model.UpdateDiscovererRequest(
        description.map(value => value),
        discovererId,
        crossAccount.map(value => value)
      )
    def description: Option[__stringMin0Max256]
    def discovererId: __string
    def crossAccount: Option[__boolean]
    def getDescription: ZIO[Any, AwsError, __stringMin0Max256] =
      AwsError.unwrapOptionField("description", description)
    def getDiscovererId: ZIO[Any, Nothing, __string] = ZIO.succeed(discovererId)
    def getCrossAccount: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("crossAccount", crossAccount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.UpdateDiscovererRequest
  ) extends zio.aws.schemas.model.UpdateDiscovererRequest.ReadOnly {
    override val description: Option[__stringMin0Max256] =
      scala.Option(impl.description()).map(value => value: __stringMin0Max256)
    override val discovererId: __string = impl.discovererId(): __string
    override val crossAccount: Option[__boolean] =
      scala.Option(impl.crossAccount()).map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.UpdateDiscovererRequest
  ): zio.aws.schemas.model.UpdateDiscovererRequest.ReadOnly = new Wrapper(impl)
}
