package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyRequest(
    policy: __string,
    registryName: Option[__string] = None,
    revisionId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest
      .builder()
      .policy(policy: java.lang.String)
      .optionallyWith(registryName.map(value => value: java.lang.String))(
        _.registryName
      )
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.schemas.model.PutResourcePolicyRequest.wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.PutResourcePolicyRequest =
      zio.aws.schemas.model.PutResourcePolicyRequest(
        policy,
        registryName.map(value => value),
        revisionId.map(value => value)
      )
    def policy: __string
    def registryName: Option[__string]
    def revisionId: Option[__string]
    def getPolicy: ZIO[Any, Nothing, __string] = ZIO.succeed(policy)
    def getRegistryName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryName", registryName)
    def getRevisionId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest
  ) extends zio.aws.schemas.model.PutResourcePolicyRequest.ReadOnly {
    override val policy: __string = impl.policy(): __string
    override val registryName: Option[__string] =
      scala.Option(impl.registryName()).map(value => value: __string)
    override val revisionId: Option[__string] =
      scala.Option(impl.revisionId()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest
  ): zio.aws.schemas.model.PutResourcePolicyRequest.ReadOnly = new Wrapper(impl)
}
