package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DescribeRegistryResponse(
    description: Option[__string] = None,
    registryArn: Option[__string] = None,
    registryName: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse = {
    import DescribeRegistryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(registryArn.map(value => value: java.lang.String))(
        _.registryArn
      )
      .optionallyWith(registryName.map(value => value: java.lang.String))(
        _.registryName
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.DescribeRegistryResponse.ReadOnly =
    zio.aws.schemas.model.DescribeRegistryResponse.wrap(buildAwsValue())
}
object DescribeRegistryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.DescribeRegistryResponse =
      zio.aws.schemas.model.DescribeRegistryResponse(
        description.map(value => value),
        registryArn.map(value => value),
        registryName.map(value => value),
        tags.map(value => value)
      )
    def description: Option[__string]
    def registryArn: Option[__string]
    def registryName: Option[__string]
    def tags: Option[Map[__string, __string]]
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getRegistryArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryArn", registryArn)
    def getRegistryName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryName", registryName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse
  ) extends zio.aws.schemas.model.DescribeRegistryResponse.ReadOnly {
    override val description: Option[__string] =
      scala.Option(impl.description()).map(value => value: __string)
    override val registryArn: Option[__string] =
      scala.Option(impl.registryArn()).map(value => value: __string)
    override val registryName: Option[__string] =
      scala.Option(impl.registryName()).map(value => value: __string)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse
  ): zio.aws.schemas.model.DescribeRegistryResponse.ReadOnly = new Wrapper(impl)
}
