package zio.aws.schemas
import zio.aws.schemas.model.DescribeDiscovererResponse.ReadOnly
import zio.aws.schemas.model.{
  ListDiscoverersRequest,
  DescribeRegistryRequest,
  CreateRegistryRequest,
  DescribeSchemaRequest,
  PutResourcePolicyRequest,
  ListSchemasRequest,
  ListTagsForResourceRequest,
  CreateDiscovererRequest,
  SearchSchemasRequest,
  CreateSchemaRequest,
  UpdateRegistryRequest,
  DeleteRegistryRequest,
  StopDiscovererRequest,
  ListRegistriesRequest,
  DeleteDiscovererRequest,
  DescribeDiscovererRequest,
  GetCodeBindingSourceRequest,
  UpdateSchemaRequest,
  DeleteSchemaVersionRequest,
  DeleteResourcePolicyRequest,
  UntagResourceRequest,
  ExportSchemaRequest,
  PutCodeBindingRequest,
  GetDiscoveredSchemaRequest,
  ListSchemaVersionsRequest,
  DescribeCodeBindingRequest,
  DeleteSchemaRequest,
  GetResourcePolicyRequest,
  UpdateDiscovererRequest,
  StartDiscovererRequest,
  TagResourceRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.schemas.model.{
  CreateRegistryResponse,
  RegistrySummary,
  DescribeSchemaResponse,
  GetResourcePolicyResponse,
  CreateSchemaResponse,
  PutResourcePolicyResponse,
  ListSchemaVersionsResponse,
  ListRegistriesResponse,
  GetCodeBindingSourceResponse,
  SearchSchemaSummary,
  ExportSchemaResponse,
  GetDiscoveredSchemaResponse,
  DescribeCodeBindingResponse,
  SchemaVersionSummary,
  StopDiscovererResponse,
  DiscovererSummary,
  ListSchemasResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DescribeDiscovererResponse,
  DeleteSchemaResponse,
  SearchSchemasResponse,
  DeleteDiscovererResponse,
  ListDiscoverersResponse,
  StartDiscovererResponse,
  DeleteRegistryResponse,
  UpdateSchemaResponse,
  SchemaSummary,
  PutCodeBindingResponse,
  DescribeRegistryResponse,
  UpdateDiscovererResponse,
  UpdateRegistryResponse,
  DeleteResourcePolicyResponse,
  TagResourceResponse,
  CreateDiscovererResponse,
  DeleteSchemaVersionResponse
}
import software.amazon.awssdk.services.schemas.{
  SchemasAsyncClientBuilder,
  SchemasAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Schemas extends AspectSupport[Schemas] {
  val api: SchemasAsyncClient
  def stopDiscoverer(
      request: StopDiscovererRequest
  ): IO[AwsError, zio.aws.schemas.model.StopDiscovererResponse.ReadOnly]
  def createRegistry(
      request: CreateRegistryRequest
  ): IO[AwsError, zio.aws.schemas.model.CreateRegistryResponse.ReadOnly]
  def searchSchemas(
      request: SearchSchemasRequest
  ): ZStream[Any, AwsError, zio.aws.schemas.model.SearchSchemaSummary.ReadOnly]
  def searchSchemasPaginated(
      request: SearchSchemasRequest
  ): IO[AwsError, zio.aws.schemas.model.SearchSchemasResponse.ReadOnly]
  def listRegistries(
      request: ListRegistriesRequest
  ): ZStream[Any, AwsError, zio.aws.schemas.model.RegistrySummary.ReadOnly]
  def listRegistriesPaginated(
      request: ListRegistriesRequest
  ): IO[AwsError, zio.aws.schemas.model.ListRegistriesResponse.ReadOnly]
  def startDiscoverer(
      request: StartDiscovererRequest
  ): IO[AwsError, zio.aws.schemas.model.StartDiscovererResponse.ReadOnly]
  def getDiscoveredSchema(
      request: GetDiscoveredSchemaRequest
  ): IO[AwsError, zio.aws.schemas.model.GetDiscoveredSchemaResponse.ReadOnly]
  def updateDiscoverer(
      request: UpdateDiscovererRequest
  ): IO[AwsError, zio.aws.schemas.model.UpdateDiscovererResponse.ReadOnly]
  def putResourcePolicy(
      request: PutResourcePolicyRequest
  ): IO[AwsError, zio.aws.schemas.model.PutResourcePolicyResponse.ReadOnly]
  def describeSchema(
      request: DescribeSchemaRequest
  ): IO[AwsError, zio.aws.schemas.model.DescribeSchemaResponse.ReadOnly]
  def describeRegistry(
      request: DescribeRegistryRequest
  ): IO[AwsError, zio.aws.schemas.model.DescribeRegistryResponse.ReadOnly]
  def describeCodeBinding(
      request: DescribeCodeBindingRequest
  ): IO[AwsError, zio.aws.schemas.model.DescribeCodeBindingResponse.ReadOnly]
  def deleteSchemaVersion(
      request: DeleteSchemaVersionRequest
  ): IO[AwsError, Unit]
  def updateSchema(
      request: UpdateSchemaRequest
  ): IO[AwsError, zio.aws.schemas.model.UpdateSchemaResponse.ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def deleteRegistry(request: DeleteRegistryRequest): IO[AwsError, Unit]
  def deleteResourcePolicy(
      request: DeleteResourcePolicyRequest
  ): IO[AwsError, Unit]
  def exportSchema(
      request: ExportSchemaRequest
  ): IO[AwsError, zio.aws.schemas.model.ExportSchemaResponse.ReadOnly]
  def deleteDiscoverer(request: DeleteDiscovererRequest): IO[AwsError, Unit]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.schemas.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def createSchema(
      request: CreateSchemaRequest
  ): IO[AwsError, zio.aws.schemas.model.CreateSchemaResponse.ReadOnly]
  def getCodeBindingSource(
      request: GetCodeBindingSourceRequest
  ): IO[AwsError, zio.aws.schemas.model.GetCodeBindingSourceResponse.ReadOnly]
  def deleteSchema(request: DeleteSchemaRequest): IO[AwsError, Unit]
  def getResourcePolicy(
      request: GetResourcePolicyRequest
  ): IO[AwsError, zio.aws.schemas.model.GetResourcePolicyResponse.ReadOnly]
  def listSchemaVersions(
      request: ListSchemaVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.schemas.model.SchemaVersionSummary.ReadOnly]
  def listSchemaVersionsPaginated(
      request: ListSchemaVersionsRequest
  ): IO[AwsError, zio.aws.schemas.model.ListSchemaVersionsResponse.ReadOnly]
  def updateRegistry(
      request: UpdateRegistryRequest
  ): IO[AwsError, zio.aws.schemas.model.UpdateRegistryResponse.ReadOnly]
  def describeDiscoverer(
      request: DescribeDiscovererRequest
  ): IO[AwsError, ReadOnly]
  def listSchemas(
      request: ListSchemasRequest
  ): ZStream[Any, AwsError, zio.aws.schemas.model.SchemaSummary.ReadOnly]
  def listSchemasPaginated(
      request: ListSchemasRequest
  ): IO[AwsError, zio.aws.schemas.model.ListSchemasResponse.ReadOnly]
  def putCodeBinding(
      request: PutCodeBindingRequest
  ): IO[AwsError, zio.aws.schemas.model.PutCodeBindingResponse.ReadOnly]
  def listDiscoverers(
      request: ListDiscoverersRequest
  ): ZStream[Any, AwsError, zio.aws.schemas.model.DiscovererSummary.ReadOnly]
  def listDiscoverersPaginated(
      request: ListDiscoverersRequest
  ): IO[AwsError, zio.aws.schemas.model.ListDiscoverersResponse.ReadOnly]
  def createDiscoverer(
      request: CreateDiscovererRequest
  ): IO[AwsError, zio.aws.schemas.model.CreateDiscovererResponse.ReadOnly]
}
object Schemas {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Schemas] = customized(
    identity
  )
  def customized(
      customization: SchemasAsyncClientBuilder => SchemasAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Schemas] = managed(
    customization
  ).toLayer
  def managed(
      customization: SchemasAsyncClientBuilder => SchemasAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Schemas] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = SchemasAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SchemasAsyncClient, SchemasAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[SchemasAsyncClient, SchemasAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new SchemasImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SchemasImpl[R](
      override val api: SchemasAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Schemas
      with AwsServiceBase[R] {
    override val serviceName: String = "Schemas"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SchemasImpl[R1] = new SchemasImpl(api, newAspect, r)
    def stopDiscoverer(
        request: StopDiscovererRequest
    ): IO[AwsError, zio.aws.schemas.model.StopDiscovererResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.StopDiscovererRequest,
        StopDiscovererResponse
      ]("stopDiscoverer", api.stopDiscoverer)(request.buildAwsValue())
        .map(zio.aws.schemas.model.StopDiscovererResponse.wrap)
        .provideEnvironment(r)
    def createRegistry(
        request: CreateRegistryRequest
    ): IO[AwsError, zio.aws.schemas.model.CreateRegistryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.CreateRegistryRequest,
        CreateRegistryResponse
      ]("createRegistry", api.createRegistry)(request.buildAwsValue())
        .map(zio.aws.schemas.model.CreateRegistryResponse.wrap)
        .provideEnvironment(r)
    def searchSchemas(request: SearchSchemasRequest): ZStream[
      Any,
      AwsError,
      zio.aws.schemas.model.SearchSchemaSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.schemas.model.SearchSchemasRequest,
      SearchSchemasResponse,
      SearchSchemaSummary
    ](
      "searchSchemas",
      api.searchSchemas,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.schemas().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.schemas.model.SearchSchemaSummary.wrap(item))
      .provideEnvironment(r)
    def searchSchemasPaginated(
        request: SearchSchemasRequest
    ): IO[AwsError, zio.aws.schemas.model.SearchSchemasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.SearchSchemasRequest,
        SearchSchemasResponse
      ]("searchSchemas", api.searchSchemas)(request.buildAwsValue())
        .map(zio.aws.schemas.model.SearchSchemasResponse.wrap)
        .provideEnvironment(r)
    def listRegistries(
        request: ListRegistriesRequest
    ): ZStream[Any, AwsError, zio.aws.schemas.model.RegistrySummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.schemas.model.ListRegistriesRequest,
        ListRegistriesResponse,
        RegistrySummary
      ](
        "listRegistries",
        api.listRegistries,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.registries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.schemas.model.RegistrySummary.wrap(item))
        .provideEnvironment(r)
    def listRegistriesPaginated(
        request: ListRegistriesRequest
    ): IO[AwsError, zio.aws.schemas.model.ListRegistriesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.ListRegistriesRequest,
        ListRegistriesResponse
      ]("listRegistries", api.listRegistries)(request.buildAwsValue())
        .map(zio.aws.schemas.model.ListRegistriesResponse.wrap)
        .provideEnvironment(r)
    def startDiscoverer(
        request: StartDiscovererRequest
    ): IO[AwsError, zio.aws.schemas.model.StartDiscovererResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.StartDiscovererRequest,
        StartDiscovererResponse
      ]("startDiscoverer", api.startDiscoverer)(request.buildAwsValue())
        .map(zio.aws.schemas.model.StartDiscovererResponse.wrap)
        .provideEnvironment(r)
    def getDiscoveredSchema(request: GetDiscoveredSchemaRequest): IO[
      AwsError,
      zio.aws.schemas.model.GetDiscoveredSchemaResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaRequest,
      GetDiscoveredSchemaResponse
    ]("getDiscoveredSchema", api.getDiscoveredSchema)(request.buildAwsValue())
      .map(zio.aws.schemas.model.GetDiscoveredSchemaResponse.wrap)
      .provideEnvironment(r)
    def updateDiscoverer(
        request: UpdateDiscovererRequest
    ): IO[AwsError, zio.aws.schemas.model.UpdateDiscovererResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.UpdateDiscovererRequest,
        UpdateDiscovererResponse
      ]("updateDiscoverer", api.updateDiscoverer)(request.buildAwsValue())
        .map(zio.aws.schemas.model.UpdateDiscovererResponse.wrap)
        .provideEnvironment(r)
    def putResourcePolicy(
        request: PutResourcePolicyRequest
    ): IO[AwsError, zio.aws.schemas.model.PutResourcePolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest,
        PutResourcePolicyResponse
      ]("putResourcePolicy", api.putResourcePolicy)(request.buildAwsValue())
        .map(zio.aws.schemas.model.PutResourcePolicyResponse.wrap)
        .provideEnvironment(r)
    def describeSchema(
        request: DescribeSchemaRequest
    ): IO[AwsError, zio.aws.schemas.model.DescribeSchemaResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.DescribeSchemaRequest,
        DescribeSchemaResponse
      ]("describeSchema", api.describeSchema)(request.buildAwsValue())
        .map(zio.aws.schemas.model.DescribeSchemaResponse.wrap)
        .provideEnvironment(r)
    def describeRegistry(
        request: DescribeRegistryRequest
    ): IO[AwsError, zio.aws.schemas.model.DescribeRegistryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.DescribeRegistryRequest,
        DescribeRegistryResponse
      ]("describeRegistry", api.describeRegistry)(request.buildAwsValue())
        .map(zio.aws.schemas.model.DescribeRegistryResponse.wrap)
        .provideEnvironment(r)
    def describeCodeBinding(request: DescribeCodeBindingRequest): IO[
      AwsError,
      zio.aws.schemas.model.DescribeCodeBindingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.schemas.model.DescribeCodeBindingRequest,
      DescribeCodeBindingResponse
    ]("describeCodeBinding", api.describeCodeBinding)(request.buildAwsValue())
      .map(zio.aws.schemas.model.DescribeCodeBindingResponse.wrap)
      .provideEnvironment(r)
    def deleteSchemaVersion(
        request: DeleteSchemaVersionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionRequest,
      DeleteSchemaVersionResponse
    ]("deleteSchemaVersion", api.deleteSchemaVersion)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateSchema(
        request: UpdateSchemaRequest
    ): IO[AwsError, zio.aws.schemas.model.UpdateSchemaResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest,
        UpdateSchemaResponse
      ]("updateSchema", api.updateSchema)(request.buildAwsValue())
        .map(zio.aws.schemas.model.UpdateSchemaResponse.wrap)
        .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteRegistry(request: DeleteRegistryRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.DeleteRegistryRequest,
        DeleteRegistryResponse
      ]("deleteRegistry", api.deleteRegistry)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteResourcePolicy(
        request: DeleteResourcePolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyRequest,
      DeleteResourcePolicyResponse
    ]("deleteResourcePolicy", api.deleteResourcePolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def exportSchema(
        request: ExportSchemaRequest
    ): IO[AwsError, zio.aws.schemas.model.ExportSchemaResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.ExportSchemaRequest,
        ExportSchemaResponse
      ]("exportSchema", api.exportSchema)(request.buildAwsValue())
        .map(zio.aws.schemas.model.ExportSchemaResponse.wrap)
        .provideEnvironment(r)
    def deleteDiscoverer(request: DeleteDiscovererRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.DeleteDiscovererRequest,
        DeleteDiscovererResponse
      ]("deleteDiscoverer", api.deleteDiscoverer)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.schemas.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.schemas.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.schemas.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createSchema(
        request: CreateSchemaRequest
    ): IO[AwsError, zio.aws.schemas.model.CreateSchemaResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.CreateSchemaRequest,
        CreateSchemaResponse
      ]("createSchema", api.createSchema)(request.buildAwsValue())
        .map(zio.aws.schemas.model.CreateSchemaResponse.wrap)
        .provideEnvironment(r)
    def getCodeBindingSource(request: GetCodeBindingSourceRequest): IO[
      AwsError,
      zio.aws.schemas.model.GetCodeBindingSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceRequest,
      GetCodeBindingSourceResponse
    ]("getCodeBindingSource", api.getCodeBindingSource)(request.buildAwsValue())
      .map(zio.aws.schemas.model.GetCodeBindingSourceResponse.wrap)
      .provideEnvironment(r)
    def deleteSchema(request: DeleteSchemaRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.DeleteSchemaRequest,
        DeleteSchemaResponse
      ]("deleteSchema", api.deleteSchema)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getResourcePolicy(
        request: GetResourcePolicyRequest
    ): IO[AwsError, zio.aws.schemas.model.GetResourcePolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.GetResourcePolicyRequest,
        GetResourcePolicyResponse
      ]("getResourcePolicy", api.getResourcePolicy)(request.buildAwsValue())
        .map(zio.aws.schemas.model.GetResourcePolicyResponse.wrap)
        .provideEnvironment(r)
    def listSchemaVersions(request: ListSchemaVersionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.schemas.model.SchemaVersionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest,
      ListSchemaVersionsResponse,
      SchemaVersionSummary
    ](
      "listSchemaVersions",
      api.listSchemaVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.schemaVersions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.schemas.model.SchemaVersionSummary.wrap(item))
      .provideEnvironment(r)
    def listSchemaVersionsPaginated(
        request: ListSchemaVersionsRequest
    ): IO[AwsError, zio.aws.schemas.model.ListSchemaVersionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest,
        ListSchemaVersionsResponse
      ]("listSchemaVersions", api.listSchemaVersions)(request.buildAwsValue())
        .map(zio.aws.schemas.model.ListSchemaVersionsResponse.wrap)
        .provideEnvironment(r)
    def updateRegistry(
        request: UpdateRegistryRequest
    ): IO[AwsError, zio.aws.schemas.model.UpdateRegistryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.UpdateRegistryRequest,
        UpdateRegistryResponse
      ]("updateRegistry", api.updateRegistry)(request.buildAwsValue())
        .map(zio.aws.schemas.model.UpdateRegistryResponse.wrap)
        .provideEnvironment(r)
    def describeDiscoverer(
        request: DescribeDiscovererRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.schemas.model.DescribeDiscovererRequest,
      DescribeDiscovererResponse
    ]("describeDiscoverer", api.describeDiscoverer)(request.buildAwsValue())
      .map(zio.aws.schemas.model.DescribeDiscovererResponse.wrap)
      .provideEnvironment(r)
    def listSchemas(
        request: ListSchemasRequest
    ): ZStream[Any, AwsError, zio.aws.schemas.model.SchemaSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.schemas.model.ListSchemasRequest,
        ListSchemasResponse,
        SchemaSummary
      ](
        "listSchemas",
        api.listSchemas,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.schemas().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.schemas.model.SchemaSummary.wrap(item))
        .provideEnvironment(r)
    def listSchemasPaginated(
        request: ListSchemasRequest
    ): IO[AwsError, zio.aws.schemas.model.ListSchemasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.ListSchemasRequest,
        ListSchemasResponse
      ]("listSchemas", api.listSchemas)(request.buildAwsValue())
        .map(zio.aws.schemas.model.ListSchemasResponse.wrap)
        .provideEnvironment(r)
    def putCodeBinding(
        request: PutCodeBindingRequest
    ): IO[AwsError, zio.aws.schemas.model.PutCodeBindingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest,
        PutCodeBindingResponse
      ]("putCodeBinding", api.putCodeBinding)(request.buildAwsValue())
        .map(zio.aws.schemas.model.PutCodeBindingResponse.wrap)
        .provideEnvironment(r)
    def listDiscoverers(request: ListDiscoverersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.schemas.model.DiscovererSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest,
      ListDiscoverersResponse,
      DiscovererSummary
    ](
      "listDiscoverers",
      api.listDiscoverers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.discoverers().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.schemas.model.DiscovererSummary.wrap(item))
      .provideEnvironment(r)
    def listDiscoverersPaginated(
        request: ListDiscoverersRequest
    ): IO[AwsError, zio.aws.schemas.model.ListDiscoverersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest,
        ListDiscoverersResponse
      ]("listDiscoverers", api.listDiscoverers)(request.buildAwsValue())
        .map(zio.aws.schemas.model.ListDiscoverersResponse.wrap)
        .provideEnvironment(r)
    def createDiscoverer(
        request: CreateDiscovererRequest
    ): IO[AwsError, zio.aws.schemas.model.CreateDiscovererResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.schemas.model.CreateDiscovererRequest,
        CreateDiscovererResponse
      ]("createDiscoverer", api.createDiscoverer)(request.buildAwsValue())
        .map(zio.aws.schemas.model.CreateDiscovererResponse.wrap)
        .provideEnvironment(r)
  }
  def stopDiscoverer(request: StopDiscovererRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.StopDiscovererResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDiscoverer(request))
  def createRegistry(request: CreateRegistryRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.CreateRegistryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRegistry(request))
  def searchSchemas(request: SearchSchemasRequest): ZStream[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.SearchSchemaSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchSchemas(request))
  def searchSchemasPaginated(request: SearchSchemasRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.SearchSchemasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchSchemasPaginated(request))
  def listRegistries(request: ListRegistriesRequest): ZStream[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.RegistrySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRegistries(request))
  def listRegistriesPaginated(request: ListRegistriesRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.ListRegistriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRegistriesPaginated(request))
  def startDiscoverer(request: StartDiscovererRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.StartDiscovererResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDiscoverer(request))
  def getDiscoveredSchema(request: GetDiscoveredSchemaRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.GetDiscoveredSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDiscoveredSchema(request))
  def updateDiscoverer(request: UpdateDiscovererRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.UpdateDiscovererResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDiscoverer(request))
  def putResourcePolicy(request: PutResourcePolicyRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.PutResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourcePolicy(request))
  def describeSchema(request: DescribeSchemaRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.DescribeSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSchema(request))
  def describeRegistry(request: DescribeRegistryRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.DescribeRegistryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRegistry(request))
  def describeCodeBinding(request: DescribeCodeBindingRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.DescribeCodeBindingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCodeBinding(request))
  def deleteSchemaVersion(
      request: DeleteSchemaVersionRequest
  ): ZIO[zio.aws.schemas.Schemas, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSchemaVersion(request))
  def updateSchema(request: UpdateSchemaRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.UpdateSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSchema(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.schemas.Schemas, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def deleteRegistry(
      request: DeleteRegistryRequest
  ): ZIO[zio.aws.schemas.Schemas, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRegistry(request))
  def deleteResourcePolicy(
      request: DeleteResourcePolicyRequest
  ): ZIO[zio.aws.schemas.Schemas, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteResourcePolicy(request))
  def exportSchema(request: ExportSchemaRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.ExportSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportSchema(request))
  def deleteDiscoverer(
      request: DeleteDiscovererRequest
  ): ZIO[zio.aws.schemas.Schemas, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDiscoverer(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.schemas.Schemas, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def createSchema(request: CreateSchemaRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.CreateSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSchema(request))
  def getCodeBindingSource(request: GetCodeBindingSourceRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.GetCodeBindingSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCodeBindingSource(request))
  def deleteSchema(
      request: DeleteSchemaRequest
  ): ZIO[zio.aws.schemas.Schemas, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSchema(request))
  def getResourcePolicy(request: GetResourcePolicyRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.GetResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourcePolicy(request))
  def listSchemaVersions(request: ListSchemaVersionsRequest): ZStream[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.SchemaVersionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSchemaVersions(request))
  def listSchemaVersionsPaginated(request: ListSchemaVersionsRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.ListSchemaVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSchemaVersionsPaginated(request))
  def updateRegistry(request: UpdateRegistryRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.UpdateRegistryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRegistry(request))
  def describeDiscoverer(
      request: DescribeDiscovererRequest
  ): ZIO[zio.aws.schemas.Schemas, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeDiscoverer(request))
  def listSchemas(request: ListSchemasRequest): ZStream[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.SchemaSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSchemas(request))
  def listSchemasPaginated(request: ListSchemasRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.ListSchemasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSchemasPaginated(request))
  def putCodeBinding(request: PutCodeBindingRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.PutCodeBindingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putCodeBinding(request))
  def listDiscoverers(request: ListDiscoverersRequest): ZStream[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.DiscovererSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDiscoverers(request))
  def listDiscoverersPaginated(request: ListDiscoverersRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.ListDiscoverersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDiscoverersPaginated(request))
  def createDiscoverer(request: CreateDiscovererRequest): ZIO[
    zio.aws.schemas.Schemas,
    AwsError,
    zio.aws.schemas.model.CreateDiscovererResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDiscoverer(request))
}
