package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters._
final case class CreateDiscovererResponse(
    description: Option[__string] = None,
    discovererArn: Option[__string] = None,
    discovererId: Option[__string] = None,
    sourceArn: Option[__string] = None,
    state: Option[zio.aws.schemas.model.DiscovererState] = None,
    crossAccount: Option[__boolean] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.CreateDiscovererResponse = {
    import CreateDiscovererResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.CreateDiscovererResponse
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(discovererArn.map(value => value: java.lang.String))(
        _.discovererArn
      )
      .optionallyWith(discovererId.map(value => value: java.lang.String))(
        _.discovererId
      )
      .optionallyWith(sourceArn.map(value => value: java.lang.String))(
        _.sourceArn
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(crossAccount.map(value => value: java.lang.Boolean))(
        _.crossAccount
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.CreateDiscovererResponse.ReadOnly =
    zio.aws.schemas.model.CreateDiscovererResponse.wrap(buildAwsValue())
}
object CreateDiscovererResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.CreateDiscovererResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.CreateDiscovererResponse =
      zio.aws.schemas.model.CreateDiscovererResponse(
        description.map(value => value),
        discovererArn.map(value => value),
        discovererId.map(value => value),
        sourceArn.map(value => value),
        state.map(value => value),
        crossAccount.map(value => value),
        tags.map(value => value)
      )
    def description: Option[__string]
    def discovererArn: Option[__string]
    def discovererId: Option[__string]
    def sourceArn: Option[__string]
    def state: Option[zio.aws.schemas.model.DiscovererState]
    def crossAccount: Option[__boolean]
    def tags: Option[Map[__string, __string]]
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getDiscovererArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("discovererArn", discovererArn)
    def getDiscovererId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("discovererId", discovererId)
    def getSourceArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getState: ZIO[Any, AwsError, zio.aws.schemas.model.DiscovererState] =
      AwsError.unwrapOptionField("state", state)
    def getCrossAccount: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("crossAccount", crossAccount)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.CreateDiscovererResponse
  ) extends zio.aws.schemas.model.CreateDiscovererResponse.ReadOnly {
    override val description: Option[__string] =
      scala.Option(impl.description()).map(value => value: __string)
    override val discovererArn: Option[__string] =
      scala.Option(impl.discovererArn()).map(value => value: __string)
    override val discovererId: Option[__string] =
      scala.Option(impl.discovererId()).map(value => value: __string)
    override val sourceArn: Option[__string] =
      scala.Option(impl.sourceArn()).map(value => value: __string)
    override val state: Option[zio.aws.schemas.model.DiscovererState] = scala
      .Option(impl.state())
      .map(value => zio.aws.schemas.model.DiscovererState.wrap(value))
    override val crossAccount: Option[__boolean] =
      scala.Option(impl.crossAccount()).map(value => value: __boolean)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.CreateDiscovererResponse
  ): zio.aws.schemas.model.CreateDiscovererResponse.ReadOnly = new Wrapper(impl)
}
