package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.{__string, __stringMin0Max256}
import scala.jdk.CollectionConverters._
final case class UpdateRegistryRequest(
    description: Option[__stringMin0Max256] = None,
    registryName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.UpdateRegistryRequest = {
    import UpdateRegistryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.UpdateRegistryRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .registryName(registryName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.UpdateRegistryRequest.ReadOnly =
    zio.aws.schemas.model.UpdateRegistryRequest.wrap(buildAwsValue())
}
object UpdateRegistryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.UpdateRegistryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.UpdateRegistryRequest =
      zio.aws.schemas.model
        .UpdateRegistryRequest(description.map(value => value), registryName)
    def description: Option[__stringMin0Max256]
    def registryName: __string
    def getDescription: ZIO[Any, AwsError, __stringMin0Max256] =
      AwsError.unwrapOptionField("description", description)
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.UpdateRegistryRequest
  ) extends zio.aws.schemas.model.UpdateRegistryRequest.ReadOnly {
    override val description: Option[__stringMin0Max256] =
      scala.Option(impl.description()).map(value => value: __stringMin0Max256)
    override val registryName: __string = impl.registryName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.UpdateRegistryRequest
  ): zio.aws.schemas.model.UpdateRegistryRequest.ReadOnly = new Wrapper(impl)
}
