package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class GetDiscoveredSchemaResponse(content: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaResponse = {
    import GetDiscoveredSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaResponse
      .builder()
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.GetDiscoveredSchemaResponse.ReadOnly =
    zio.aws.schemas.model.GetDiscoveredSchemaResponse.wrap(buildAwsValue())
}
object GetDiscoveredSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.GetDiscoveredSchemaResponse =
      zio.aws.schemas.model
        .GetDiscoveredSchemaResponse(content.map(value => value))
    def content: Option[__string]
    def getContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("content", content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaResponse
  ) extends zio.aws.schemas.model.GetDiscoveredSchemaResponse.ReadOnly {
    override val content: Option[__string] =
      scala.Option(impl.content()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaResponse
  ): zio.aws.schemas.model.GetDiscoveredSchemaResponse.ReadOnly = new Wrapper(
    impl
  )
}
