package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class StopDiscovererResponse(
    discovererId: Option[__string] = None,
    state: Option[zio.aws.schemas.model.DiscovererState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.StopDiscovererResponse = {
    import StopDiscovererResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.StopDiscovererResponse
      .builder()
      .optionallyWith(discovererId.map(value => value: java.lang.String))(
        _.discovererId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.StopDiscovererResponse.ReadOnly =
    zio.aws.schemas.model.StopDiscovererResponse.wrap(buildAwsValue())
}
object StopDiscovererResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.StopDiscovererResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.StopDiscovererResponse =
      zio.aws.schemas.model.StopDiscovererResponse(
        discovererId.map(value => value),
        state.map(value => value)
      )
    def discovererId: Option[__string]
    def state: Option[zio.aws.schemas.model.DiscovererState]
    def getDiscovererId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("discovererId", discovererId)
    def getState: ZIO[Any, AwsError, zio.aws.schemas.model.DiscovererState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.StopDiscovererResponse
  ) extends zio.aws.schemas.model.StopDiscovererResponse.ReadOnly {
    override val discovererId: Option[__string] =
      scala.Option(impl.discovererId()).map(value => value: __string)
    override val state: Option[zio.aws.schemas.model.DiscovererState] = scala
      .Option(impl.state())
      .map(value => zio.aws.schemas.model.DiscovererState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.StopDiscovererResponse
  ): zio.aws.schemas.model.StopDiscovererResponse.ReadOnly = new Wrapper(impl)
}
