package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.schemas.model.primitives.{__long, __string, __timestampIso8601}
import scala.jdk.CollectionConverters._
final case class SchemaSummary(
    lastModified: Option[__timestampIso8601] = None,
    schemaArn: Option[__string] = None,
    schemaName: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None,
    versionCount: Option[__long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.SchemaSummary = {
    import SchemaSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.SchemaSummary
      .builder()
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .optionallyWith(schemaArn.map(value => value: java.lang.String))(
        _.schemaArn
      )
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(versionCount.map(value => value: java.lang.Long))(
        _.versionCount
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.SchemaSummary.ReadOnly =
    zio.aws.schemas.model.SchemaSummary.wrap(buildAwsValue())
}
object SchemaSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.SchemaSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.SchemaSummary =
      zio.aws.schemas.model.SchemaSummary(
        lastModified.map(value => value),
        schemaArn.map(value => value),
        schemaName.map(value => value),
        tags.map(value => value),
        versionCount.map(value => value)
      )
    def lastModified: Option[__timestampIso8601]
    def schemaArn: Option[__string]
    def schemaName: Option[__string]
    def tags: Option[Map[__string, __string]]
    def versionCount: Option[__long]
    def getLastModified: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getSchemaArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getSchemaName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVersionCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("versionCount", versionCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.SchemaSummary
  ) extends zio.aws.schemas.model.SchemaSummary.ReadOnly {
    override val lastModified: Option[__timestampIso8601] =
      scala.Option(impl.lastModified()).map(value => value: __timestampIso8601)
    override val schemaArn: Option[__string] =
      scala.Option(impl.schemaArn()).map(value => value: __string)
    override val schemaName: Option[__string] =
      scala.Option(impl.schemaName()).map(value => value: __string)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val versionCount: Option[__long] =
      scala.Option(impl.versionCount()).map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.SchemaSummary
  ): zio.aws.schemas.model.SchemaSummary.ReadOnly = new Wrapper(impl)
}
