package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class GetCodeBindingSourceRequest(
    language: __string,
    registryName: __string,
    schemaName: __string,
    schemaVersion: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceRequest = {
    import GetCodeBindingSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceRequest
      .builder()
      .language(language: java.lang.String)
      .registryName(registryName: java.lang.String)
      .schemaName(schemaName: java.lang.String)
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.GetCodeBindingSourceRequest.ReadOnly =
    zio.aws.schemas.model.GetCodeBindingSourceRequest.wrap(buildAwsValue())
}
object GetCodeBindingSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.GetCodeBindingSourceRequest =
      zio.aws.schemas.model.GetCodeBindingSourceRequest(
        language,
        registryName,
        schemaName,
        schemaVersion.map(value => value)
      )
    def language: __string
    def registryName: __string
    def schemaName: __string
    def schemaVersion: Option[__string]
    def getLanguage: ZIO[Any, Nothing, __string] = ZIO.succeed(language)
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaName: ZIO[Any, Nothing, __string] = ZIO.succeed(schemaName)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceRequest
  ) extends zio.aws.schemas.model.GetCodeBindingSourceRequest.ReadOnly {
    override val language: __string = impl.language(): __string
    override val registryName: __string = impl.registryName(): __string
    override val schemaName: __string = impl.schemaName(): __string
    override val schemaVersion: Option[__string] =
      scala.Option(impl.schemaVersion()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceRequest
  ): zio.aws.schemas.model.GetCodeBindingSourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
