package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class PutCodeBindingRequest(
    language: __string,
    registryName: __string,
    schemaName: __string,
    schemaVersion: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest = {
    import PutCodeBindingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest
      .builder()
      .language(language: java.lang.String)
      .registryName(registryName: java.lang.String)
      .schemaName(schemaName: java.lang.String)
      .optionallyWith(schemaVersion.map(value => value: java.lang.String))(
        _.schemaVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.PutCodeBindingRequest.ReadOnly =
    zio.aws.schemas.model.PutCodeBindingRequest.wrap(buildAwsValue())
}
object PutCodeBindingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.PutCodeBindingRequest =
      zio.aws.schemas.model.PutCodeBindingRequest(
        language,
        registryName,
        schemaName,
        schemaVersion.map(value => value)
      )
    def language: __string
    def registryName: __string
    def schemaName: __string
    def schemaVersion: Option[__string]
    def getLanguage: ZIO[Any, Nothing, __string] = ZIO.succeed(language)
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaName: ZIO[Any, Nothing, __string] = ZIO.succeed(schemaName)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest
  ) extends zio.aws.schemas.model.PutCodeBindingRequest.ReadOnly {
    override val language: __string = impl.language(): __string
    override val registryName: __string = impl.registryName(): __string
    override val schemaName: __string = impl.schemaName(): __string
    override val schemaVersion: Option[__string] =
      scala.Option(impl.schemaVersion()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest
  ): zio.aws.schemas.model.PutCodeBindingRequest.ReadOnly = new Wrapper(impl)
}
