package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListRegistriesResponse(
    nextToken: Option[__string] = None,
    registries: Option[Iterable[zio.aws.schemas.model.RegistrySummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ListRegistriesResponse = {
    import ListRegistriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ListRegistriesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        registries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.registries)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ListRegistriesResponse.ReadOnly =
    zio.aws.schemas.model.ListRegistriesResponse.wrap(buildAwsValue())
}
object ListRegistriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ListRegistriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ListRegistriesResponse =
      zio.aws.schemas.model.ListRegistriesResponse(
        nextToken.map(value => value),
        registries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[__string]
    def registries: Option[List[zio.aws.schemas.model.RegistrySummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegistries: ZIO[Any, AwsError, List[
      zio.aws.schemas.model.RegistrySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("registries", registries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ListRegistriesResponse
  ) extends zio.aws.schemas.model.ListRegistriesResponse.ReadOnly {
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val registries
        : Option[List[zio.aws.schemas.model.RegistrySummary.ReadOnly]] = scala
      .Option(impl.registries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.schemas.model.RegistrySummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ListRegistriesResponse
  ): zio.aws.schemas.model.ListRegistriesResponse.ReadOnly = new Wrapper(impl)
}
