package zio.aws.schemas.model
import scala.jdk.CollectionConverters._
sealed trait DiscovererState {
  def unwrap: software.amazon.awssdk.services.schemas.model.DiscovererState
}
object DiscovererState {
  def wrap(
      value: software.amazon.awssdk.services.schemas.model.DiscovererState
  ): zio.aws.schemas.model.DiscovererState = value match {
    case software.amazon.awssdk.services.schemas.model.DiscovererState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.schemas.model.DiscovererState.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.schemas.model.DiscovererState.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.schemas.model.DiscovererState {
    override def unwrap
        : software.amazon.awssdk.services.schemas.model.DiscovererState =
      software.amazon.awssdk.services.schemas.model.DiscovererState.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTED extends zio.aws.schemas.model.DiscovererState {
    override def unwrap
        : software.amazon.awssdk.services.schemas.model.DiscovererState =
      software.amazon.awssdk.services.schemas.model.DiscovererState.STARTED
  }
  case object STOPPED extends zio.aws.schemas.model.DiscovererState {
    override def unwrap
        : software.amazon.awssdk.services.schemas.model.DiscovererState =
      software.amazon.awssdk.services.schemas.model.DiscovererState.STOPPED
  }
}
