package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DeleteResourcePolicyRequest(
    registryName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyRequest = {
    import DeleteResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyRequest
      .builder()
      .optionallyWith(registryName.map(value => value: java.lang.String))(
        _.registryName
      )
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.DeleteResourcePolicyRequest.ReadOnly =
    zio.aws.schemas.model.DeleteResourcePolicyRequest.wrap(buildAwsValue())
}
object DeleteResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.DeleteResourcePolicyRequest =
      zio.aws.schemas.model
        .DeleteResourcePolicyRequest(registryName.map(value => value))
    def registryName: Option[__string]
    def getRegistryName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryName", registryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyRequest
  ) extends zio.aws.schemas.model.DeleteResourcePolicyRequest.ReadOnly {
    override val registryName: Option[__string] =
      scala.Option(impl.registryName()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyRequest
  ): zio.aws.schemas.model.DeleteResourcePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
