package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.schemas.model.primitives.{__string, __timestampIso8601}
import scala.jdk.CollectionConverters._
final case class SearchSchemaVersionSummary(
    createdDate: Option[__timestampIso8601] = None,
    schemaVersion: Option[__string] = None,
    `type`: Option[zio.aws.schemas.model.Type] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.SearchSchemaVersionSummary = {
    import SearchSchemaVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.SearchSchemaVersionSummary
      .builder()
      .optionallyWith(
        createdDate.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        schemaVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaVersion)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.SearchSchemaVersionSummary.ReadOnly =
    zio.aws.schemas.model.SearchSchemaVersionSummary.wrap(buildAwsValue())
}
object SearchSchemaVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.SearchSchemaVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.SearchSchemaVersionSummary =
      zio.aws.schemas.model.SearchSchemaVersionSummary(
        createdDate.map(value => value),
        schemaVersion.map(value => value),
        `type`.map(value => value)
      )
    def createdDate: Option[__timestampIso8601]
    def schemaVersion: Option[__string]
    def `type`: Option[zio.aws.schemas.model.Type]
    def getCreatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getType: ZIO[Any, AwsError, zio.aws.schemas.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.SearchSchemaVersionSummary
  ) extends zio.aws.schemas.model.SearchSchemaVersionSummary.ReadOnly {
    override val createdDate: Option[__timestampIso8601] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.schemas.model.primitives.__timestampIso8601(value))
    override val schemaVersion: Option[__string] = scala
      .Option(impl.schemaVersion())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val `type`: Option[zio.aws.schemas.model.Type] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.schemas.model.Type.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.SearchSchemaVersionSummary
  ): zio.aws.schemas.model.SearchSchemaVersionSummary.ReadOnly = new Wrapper(
    impl
  )
}
