package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListSchemaVersionsResponse(
    nextToken: Option[__string] = None,
    schemaVersions: Option[
      Iterable[zio.aws.schemas.model.SchemaVersionSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse = {
    import ListSchemaVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        schemaVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schemaVersions)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ListSchemaVersionsResponse.ReadOnly =
    zio.aws.schemas.model.ListSchemaVersionsResponse.wrap(buildAwsValue())
}
object ListSchemaVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ListSchemaVersionsResponse =
      zio.aws.schemas.model.ListSchemaVersionsResponse(
        nextToken.map(value => value),
        schemaVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[__string]
    def schemaVersions
        : Option[List[zio.aws.schemas.model.SchemaVersionSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSchemaVersions: ZIO[Any, AwsError, List[
      zio.aws.schemas.model.SchemaVersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("schemaVersions", schemaVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse
  ) extends zio.aws.schemas.model.ListSchemaVersionsResponse.ReadOnly {
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val schemaVersions
        : Option[List[zio.aws.schemas.model.SchemaVersionSummary.ReadOnly]] =
      scala
        .Option(impl.schemaVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.schemas.model.SchemaVersionSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse
  ): zio.aws.schemas.model.ListSchemaVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
