package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListSchemasResponse(
    nextToken: Option[__string] = None,
    schemas: Option[Iterable[zio.aws.schemas.model.SchemaSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.ListSchemasResponse = {
    import ListSchemasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.ListSchemasResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        schemas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schemas)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.ListSchemasResponse.ReadOnly =
    zio.aws.schemas.model.ListSchemasResponse.wrap(buildAwsValue())
}
object ListSchemasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.ListSchemasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.ListSchemasResponse =
      zio.aws.schemas.model.ListSchemasResponse(
        nextToken.map(value => value),
        schemas.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[__string]
    def schemas: Option[List[zio.aws.schemas.model.SchemaSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSchemas: ZIO[Any, AwsError, List[
      zio.aws.schemas.model.SchemaSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("schemas", schemas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.ListSchemasResponse
  ) extends zio.aws.schemas.model.ListSchemasResponse.ReadOnly {
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val schemas
        : Option[List[zio.aws.schemas.model.SchemaSummary.ReadOnly]] = scala
      .Option(impl.schemas())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.schemas.model.SchemaSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.ListSchemasResponse
  ): zio.aws.schemas.model.ListSchemasResponse.ReadOnly = new Wrapper(impl)
}
