package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.{
  __string,
  __stringMin0Max256,
  __stringMin1Max100000,
  __stringMin0Max36
}
import scala.jdk.CollectionConverters._
final case class UpdateSchemaRequest(
    clientTokenId: Option[__stringMin0Max36] = None,
    content: Option[__stringMin1Max100000] = None,
    description: Option[__stringMin0Max256] = None,
    registryName: __string,
    schemaName: __string,
    `type`: Option[zio.aws.schemas.model.Type] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest = {
    import UpdateSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest
      .builder()
      .optionallyWith(
        clientTokenId.map(value =>
          __stringMin0Max36.unwrap(value): java.lang.String
        )
      )(_.clientTokenId)
      .optionallyWith(
        content.map(value =>
          __stringMin1Max100000.unwrap(value): java.lang.String
        )
      )(_.content)
      .optionallyWith(
        description.map(value =>
          __stringMin0Max256.unwrap(value): java.lang.String
        )
      )(_.description)
      .registryName(__string.unwrap(registryName): java.lang.String)
      .schemaName(__string.unwrap(schemaName): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.UpdateSchemaRequest.ReadOnly =
    zio.aws.schemas.model.UpdateSchemaRequest.wrap(buildAwsValue())
}
object UpdateSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.UpdateSchemaRequest =
      zio.aws.schemas.model.UpdateSchemaRequest(
        clientTokenId.map(value => value),
        content.map(value => value),
        description.map(value => value),
        registryName,
        schemaName,
        `type`.map(value => value)
      )
    def clientTokenId: Option[__stringMin0Max36]
    def content: Option[__stringMin1Max100000]
    def description: Option[__stringMin0Max256]
    def registryName: __string
    def schemaName: __string
    def `type`: Option[zio.aws.schemas.model.Type]
    def getClientTokenId: ZIO[Any, AwsError, __stringMin0Max36] =
      AwsError.unwrapOptionField("clientTokenId", clientTokenId)
    def getContent: ZIO[Any, AwsError, __stringMin1Max100000] =
      AwsError.unwrapOptionField("content", content)
    def getDescription: ZIO[Any, AwsError, __stringMin0Max256] =
      AwsError.unwrapOptionField("description", description)
    def getRegistryName: ZIO[Any, Nothing, __string] = ZIO.succeed(registryName)
    def getSchemaName: ZIO[Any, Nothing, __string] = ZIO.succeed(schemaName)
    def getType: ZIO[Any, AwsError, zio.aws.schemas.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest
  ) extends zio.aws.schemas.model.UpdateSchemaRequest.ReadOnly {
    override val clientTokenId: Option[__stringMin0Max36] = scala
      .Option(impl.clientTokenId())
      .map(value => zio.aws.schemas.model.primitives.__stringMin0Max36(value))
    override val content: Option[__stringMin1Max100000] = scala
      .Option(impl.content())
      .map(value =>
        zio.aws.schemas.model.primitives.__stringMin1Max100000(value)
      )
    override val description: Option[__stringMin0Max256] = scala
      .Option(impl.description())
      .map(value => zio.aws.schemas.model.primitives.__stringMin0Max256(value))
    override val registryName: __string =
      zio.aws.schemas.model.primitives.__string(impl.registryName())
    override val schemaName: __string =
      zio.aws.schemas.model.primitives.__string(impl.schemaName())
    override val `type`: Option[zio.aws.schemas.model.Type] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.schemas.model.Type.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest
  ): zio.aws.schemas.model.UpdateSchemaRequest.ReadOnly = new Wrapper(impl)
}
