package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UpdateRegistryResponse(
    description: Option[__string] = None,
    registryArn: Option[__string] = None,
    registryName: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.UpdateRegistryResponse = {
    import UpdateRegistryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.UpdateRegistryResponse
      .builder()
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        registryArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.registryArn)
      .optionallyWith(
        registryName.map(value => __string.unwrap(value): java.lang.String)
      )(_.registryName)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.UpdateRegistryResponse.ReadOnly =
    zio.aws.schemas.model.UpdateRegistryResponse.wrap(buildAwsValue())
}
object UpdateRegistryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.UpdateRegistryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.UpdateRegistryResponse =
      zio.aws.schemas.model.UpdateRegistryResponse(
        description.map(value => value),
        registryArn.map(value => value),
        registryName.map(value => value),
        tags.map(value => value)
      )
    def description: Option[__string]
    def registryArn: Option[__string]
    def registryName: Option[__string]
    def tags: Option[Map[__string, __string]]
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getRegistryArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryArn", registryArn)
    def getRegistryName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("registryName", registryName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.UpdateRegistryResponse
  ) extends zio.aws.schemas.model.UpdateRegistryResponse.ReadOnly {
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val registryArn: Option[__string] = scala
      .Option(impl.registryArn())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val registryName: Option[__string] = scala
      .Option(impl.registryName())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.schemas.model.primitives
              .__string(key) -> zio.aws.schemas.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.UpdateRegistryResponse
  ): zio.aws.schemas.model.UpdateRegistryResponse.ReadOnly = new Wrapper(impl)
}
