package zio.aws.schemas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.schemas.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class StartDiscovererResponse(
    discovererId: Option[__string] = None,
    state: Option[zio.aws.schemas.model.DiscovererState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.schemas.model.StartDiscovererResponse = {
    import StartDiscovererResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.schemas.model.StartDiscovererResponse
      .builder()
      .optionallyWith(
        discovererId.map(value => __string.unwrap(value): java.lang.String)
      )(_.discovererId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.schemas.model.StartDiscovererResponse.ReadOnly =
    zio.aws.schemas.model.StartDiscovererResponse.wrap(buildAwsValue())
}
object StartDiscovererResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.schemas.model.StartDiscovererResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.schemas.model.StartDiscovererResponse =
      zio.aws.schemas.model.StartDiscovererResponse(
        discovererId.map(value => value),
        state.map(value => value)
      )
    def discovererId: Option[__string]
    def state: Option[zio.aws.schemas.model.DiscovererState]
    def getDiscovererId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("discovererId", discovererId)
    def getState: ZIO[Any, AwsError, zio.aws.schemas.model.DiscovererState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.schemas.model.StartDiscovererResponse
  ) extends zio.aws.schemas.model.StartDiscovererResponse.ReadOnly {
    override val discovererId: Option[__string] = scala
      .Option(impl.discovererId())
      .map(value => zio.aws.schemas.model.primitives.__string(value))
    override val state: Option[zio.aws.schemas.model.DiscovererState] = scala
      .Option(impl.state())
      .map(value => zio.aws.schemas.model.DiscovererState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.schemas.model.StartDiscovererResponse
  ): zio.aws.schemas.model.StartDiscovererResponse.ReadOnly = new Wrapper(impl)
}
